/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.entity.obj;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.v2.block.entity.JSV2BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WireBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos connectionA = null;
    @Nullable
    private BlockPos connectionB = null;
    private Vec3 preferredDir = new Vec3(1.0, 0.0, 0.0);
    private VoxelShape cachedShape = Shapes.m_83144_();

    public WireBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JSV2BlockEntities.WIRE.get(), pos, state);
    }

    public void updateConnections() {
        Vec3 dir;
        double dist;
        Vec3 delta;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.connectionA = null;
        this.connectionB = null;
        Vec3 myCenter = Vec3.m_82512_((Vec3i)this.f_58858_);
        double radius = 2.5;
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-2, -2, -2), (BlockPos)this.f_58858_.m_7918_(2, 2, 2))) {
            BlockEntity be;
            if (pos.equals((Object)this.f_58858_) || !((be = this.f_58857_.m_7702_(pos)) instanceof WireBlockEntity)) continue;
            candidates.add(pos.m_7949_());
        }
        if (candidates.isEmpty()) {
            this.rebuildShapeCache();
            return;
        }
        Vec3 bestDirA = null;
        Vec3 bestDirB = null;
        double bestDistA = Double.MAX_VALUE;
        double bestDistB = Double.MAX_VALUE;
        for (BlockPos pos : candidates) {
            delta = Vec3.m_82512_((Vec3i)pos).m_82546_(myCenter);
            dist = delta.m_82553_();
            if (dist > radius) continue;
            dir = delta.m_82541_();
            if (Math.abs(dir.f_82480_) > 0.7 || !(dist < bestDistA)) continue;
            bestDistA = dist;
            bestDirA = dir;
            this.connectionA = pos;
        }
        if (bestDirA != null) {
            this.preferredDir = bestDirA;
        }
        for (BlockPos pos : candidates) {
            double dot;
            if (pos.equals((Object)this.connectionA) || (dist = (delta = Vec3.m_82512_((Vec3i)pos).m_82546_(myCenter)).m_82553_()) > radius || !((dot = this.preferredDir.m_82526_(dir = delta.m_82541_())) < -0.6) || !(dist < bestDistB)) continue;
            bestDistB = dist;
            bestDirB = dir;
            this.connectionB = pos;
        }
        this.rebuildShapeCache();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void rebuildShapeCache() {
        VoxelShape shape = Shapes.m_83048_((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        Vec3 center = Vec3.m_82512_((Vec3i)this.f_58858_);
        if (this.connectionA != null) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)this.createWireAABB(center, Vec3.m_82512_((Vec3i)this.connectionA), 0.1)));
        }
        if (this.connectionB != null) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)this.createWireAABB(center, Vec3.m_82512_((Vec3i)this.connectionB), 0.1)));
        }
        this.cachedShape = shape.m_83296_();
    }

    private AABB createWireAABB(Vec3 from, Vec3 to, double radius) {
        double minX = Math.min(from.f_82479_, to.f_82479_) - radius;
        double minY = Math.min(from.f_82480_, to.f_82480_) - radius;
        double minZ = Math.min(from.f_82481_, to.f_82481_) - radius;
        double maxX = Math.max(from.f_82479_, to.f_82479_) + radius;
        double maxY = Math.max(from.f_82480_, to.f_82480_) + radius;
        double maxZ = Math.max(from.f_82481_, to.f_82481_) + radius;
        return new AABB(minX - from.f_82479_ + 0.5, minY - from.f_82480_ + 0.5, minZ - from.f_82481_ + 0.5, maxX - from.f_82479_ + 0.5, maxY - from.f_82480_ + 0.5, maxZ - from.f_82481_ + 0.5);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.connectionA != null) {
            tag.m_128356_("connA", this.connectionA.m_121878_());
        }
        if (this.connectionB != null) {
            tag.m_128356_("connB", this.connectionB.m_121878_());
        }
        tag.m_128365_("dir", (Tag)WireBlockEntity.saveVec(this.preferredDir));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.connectionA = tag.m_128441_("connA") ? BlockPos.m_122022_((long)tag.m_128454_("connA")) : null;
        this.connectionB = tag.m_128441_("connB") ? BlockPos.m_122022_((long)tag.m_128454_("connB")) : null;
        this.preferredDir = WireBlockEntity.loadVec(tag.m_128469_("dir"));
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.rebuildShapeCache();
        }
    }

    private static CompoundTag saveVec(Vec3 v) {
        CompoundTag t = new CompoundTag();
        t.m_128347_("x", v.f_82479_);
        t.m_128347_("y", v.f_82480_);
        t.m_128347_("z", v.f_82481_);
        return t;
    }

    private static Vec3 loadVec(CompoundTag t) {
        return new Vec3(t.m_128459_("x"), t.m_128459_("y"), t.m_128459_("z"));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public List<Vec3> getConnectionCenters() {
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        if (this.connectionA != null) {
            list.add(Vec3.m_82512_((Vec3i)this.connectionA));
        }
        if (this.connectionB != null) {
            list.add(Vec3.m_82512_((Vec3i)this.connectionB));
        }
        return list;
    }

    @Nullable
    public BlockPos getConnectionA() {
        return this.connectionA;
    }

    @Nullable
    public BlockPos getConnectionB() {
        return this.connectionB;
    }

    public Vec3 getPreferredDir() {
        return this.preferredDir;
    }

    public VoxelShape getCachedShape() {
        return this.cachedShape;
    }
}

