/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import java.util.Optional;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomBubbleColumnBlock
extends Block
implements BucketPickup {
    public static final BooleanProperty DRAG_DOWN = BlockStateProperties.f_61430_;
    private static final int CHECK_PERIOD = 5;

    public CustomBubbleColumnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(true)));
    }

    public void m_7892_(@NotNull BlockState state, Level level, BlockPos pos, @NotNull Entity entity) {
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        if (blockstate.m_60795_()) {
            entity.m_6845_(((Boolean)state.m_61143_((Property)DRAG_DOWN)).booleanValue());
            if (!level.f_46443_) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            entity.m_20321_(((Boolean)state.m_61143_((Property)DRAG_DOWN)).booleanValue());
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        CustomBubbleColumnBlock.updateColumn((LevelAccessor)level, pos, state, level.m_8055_(pos.m_7495_()));
    }

    @NotNull
    public FluidState m_5888_(@NotNull BlockState state) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public static void updateColumn(LevelAccessor level, BlockPos pos, BlockState state) {
        CustomBubbleColumnBlock.updateColumn(level, pos, level.m_8055_(pos), state);
    }

    public static void updateColumn(LevelAccessor level, BlockPos pos, BlockState fluid, BlockState state) {
        if (CustomBubbleColumnBlock.canExistIn(fluid)) {
            BlockState blockstate = CustomBubbleColumnBlock.getColumnState(state);
            level.m_7731_(pos, blockstate, 2);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_().m_122173_(Direction.UP);
            while (CustomBubbleColumnBlock.canExistIn(level.m_8055_((BlockPos)blockpos$mutableblockpos))) {
                if (!level.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 2)) {
                    return;
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            }
        }
    }

    private static boolean canExistIn(BlockState blockState) {
        return blockState.m_60713_((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) || blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76186_() >= 8 && blockState.m_60819_().m_76170_();
    }

    private static BlockState getColumnState(BlockState blockState) {
        if (blockState.m_60713_((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get())) {
            return blockState;
        }
        return blockState.m_60713_((Block)JSV2Blocks.VOLCANIC_MAGMA.get()) ? (BlockState)((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()).m_49966_().m_61124_((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(true)) : Blocks.f_49990_.m_49966_();
    }

    public void m_214162_(BlockState state, @NotNull Level level, BlockPos pos, @NotNull RandomSource random) {
        double d0 = pos.m_123341_();
        double d1 = pos.m_123342_();
        double d2 = pos.m_123343_();
        if (((Boolean)state.m_61143_((Property)DRAG_DOWN)).booleanValue()) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123773_, d0 + 0.5, d1 + 0.8, d2, 0.0, 0.0, 0.0);
            if (random.m_188503_(200) == 0) {
                level.m_7785_(d0, d1, d2, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        } else {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.04, 0.0);
            level.m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + (double)random.m_188501_(), d1 + (double)random.m_188501_(), d2 + (double)random.m_188501_(), 0.0, 0.04, 0.0);
            if (random.m_188503_(200) == 0) {
                level.m_7785_(d0, d1, d2, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        if (!state.m_60710_((LevelReader)level, currentPos) || facing == Direction.DOWN || facing == Direction.UP && !facingState.m_60713_((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) && CustomBubbleColumnBlock.canExistIn(facingState)) {
            level.m_186460_(currentPos, (Block)this, 5);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        return blockstate.m_60713_((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) || blockstate.m_60713_((Block)JSV2Blocks.VOLCANIC_MAGMA.get());
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83040_();
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DRAG_DOWN});
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    @NotNull
    public ItemStack m_142598_(LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    @NotNull
    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }
}

