/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.particle.JSParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FumaroleBlock
extends Block {
    public static final int ERUPT_INTERVAL = 1000;
    public static final IntegerProperty HEIGHT = IntegerProperty.m_61631_((String)"height", (int)4, (int)9);

    public FumaroleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(8)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HEIGHT});
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int height = (Integer)state.m_61143_((Property)HEIGHT);
        this.explode(height, state, level, pos);
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.5f, 1.0f);
        level.m_186460_(pos, (Block)this, 1000 + level.f_46441_.m_188503_(60));
    }

    private void explode(int height, @NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos) {
        CompletableFuture.runAsync(() -> {
            for (int i = 1; i <= height; ++i) {
                BlockPos wp = pos.m_6630_(i);
                if (!level.m_46859_(wp) && !level.m_8055_(wp).m_60713_(Blocks.f_49990_)) continue;
                level.m_7654_().execute(() -> {
                    if (level.m_7654_().m_129918_() || !level.m_7654_().m_130010_()) {
                        return;
                    }
                    AABB area = new AABB(pos).m_82377_(1.6, (double)(height + 1), 1.6);
                    for (Entity e : level.m_45933_(null, area)) {
                        e.m_20256_(e.m_20184_().m_82520_(0.0, 0.3, 0.0));
                        e.f_19864_ = true;
                    }
                    level.m_8767_((ParticleOptions)JSParticles.STEAM.get(), (double)wp.m_123341_() + level.f_46441_.m_188500_(), (double)(wp.m_123342_() + 1), (double)wp.m_123343_() + level.f_46441_.m_188500_(), 10, 0.0, 0.01, 0.0, 0.1);
                });
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1000);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!level.m_8055_(pos.m_121955_(direction.m_122436_())).m_60795_()) continue;
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.4;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.4;
            level.m_7106_((ParticleOptions)JSParticles.STEAM.get(), x += (double)direction.m_122429_(), y, z += (double)direction.m_122431_(), 0.0, 0.11, 0.0);
        }
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.4;
            double y = pos.m_123342_() + 1;
            double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.4;
            level.m_7106_((ParticleOptions)JSParticles.STEAM.get(), x, y, z, 0.0, 0.11, 0.0);
        }
    }
}

