/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import jp.jurassicsaga.server.v2.block.obj.JSRailState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class JSRailBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape FLAT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape HALF_BLOCK_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final boolean isStraight;

    public static boolean isRail(Level level, BlockPos pos) {
        return JSRailBlock.isRail(level.m_8055_(pos));
    }

    public static boolean isRail(BlockState state) {
        return state.m_60734_() instanceof JSRailBlock;
    }

    protected JSRailBlock(boolean isStraight, BlockBehaviour.Properties properties) {
        super(properties);
        this.isStraight = isStraight;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        RailShape railshape = state.m_60713_((Block)this) ? (RailShape)state.m_61143_(this.getShapeProperty()) : null;
        return railshape != null && railshape.m_61745_() ? HALF_BLOCK_AABB : FLAT_AABB;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    public void m_6807_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.updateState(state, level, pos, isMoving);
        }
    }

    protected BlockState updateState(BlockState state, Level level, BlockPos pos, boolean movedByPiston) {
        state = this.updateDir(level, pos, state, true);
        if (this.isStraight) {
            level.m_213960_(state, pos, (Block)this, pos, movedByPiston);
        }
        return state;
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && level.m_8055_(pos).m_60713_((Block)this)) {
            RailShape railshape = (RailShape)state.m_61143_(this.getShapeProperty());
            if (JSRailBlock.shouldBeRemoved(pos, level, railshape)) {
                JSRailBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                level.m_7471_(pos, isMoving);
            } else {
                this.updateState(state, level, pos, block);
            }
        }
    }

    private static boolean shouldBeRemoved(BlockPos pos, Level level, RailShape shape) {
        if (!JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_())) {
            return true;
        }
        switch (shape) {
            case ASCENDING_EAST: {
                return !JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122029_());
            }
            case ASCENDING_WEST: {
                return !JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122024_());
            }
            case ASCENDING_NORTH: {
                return !JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122012_());
            }
            case ASCENDING_SOUTH: {
                return !JSRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122019_());
            }
        }
        return false;
    }

    protected void updateState(BlockState state, Level level, BlockPos pos, Block neighborBlock) {
    }

    protected BlockState updateDir(Level level, BlockPos pos, BlockState state, boolean alwaysPlace) {
        if (level.f_46443_) {
            return state;
        }
        RailShape railshape = (RailShape)state.m_61143_(this.getShapeProperty());
        return new JSRailState(level, pos, state).place(level.m_276867_(pos), alwaysPlace, railshape).getState();
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!isMoving) {
            super.m_6810_(state, level, pos, newState, isMoving);
            if (((RailShape)state.m_61143_(this.getShapeProperty())).m_61745_()) {
                level.m_46672_(pos.m_7494_(), (Block)this);
            }
            if (this.isStraight) {
                level.m_46672_(pos, (Block)this);
                level.m_46672_(pos.m_7495_(), (Block)this);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = super.m_49966_();
        Direction direction = context.m_8125_();
        boolean flag1 = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((BlockState)blockstate.m_61124_(this.getShapeProperty(), (Comparable)(flag1 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public abstract Property<RailShape> getShapeProperty();

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isStraight() {
        return this.isStraight;
    }
}

