/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import com.google.common.collect.Lists;
import java.util.List;
import jp.jurassicsaga.server.v2.block.obj.TourRailBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class JSRailState {
    private final Level level;
    private final BlockPos pos;
    private final TourRailBlock block;
    private BlockState state;
    private final boolean isStraight;
    private final List<BlockPos> connections = Lists.newArrayList();

    public JSRailState(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.block = (TourRailBlock)state.m_60734_();
        RailShape railShape = (RailShape)state.m_61143_(this.block.getShapeProperty());
        this.isStraight = this.block.isStraight();
        this.updateConnections(railShape);
    }

    private void updateConnections(RailShape shape) {
        this.connections.clear();
        switch (shape) {
            case NORTH_SOUTH: {
                this.connections.add(this.pos.m_122012_());
                this.connections.add(this.pos.m_122019_());
                break;
            }
            case EAST_WEST: {
                this.connections.add(this.pos.m_122024_());
                this.connections.add(this.pos.m_122029_());
                break;
            }
            case ASCENDING_EAST: {
                this.connections.add(this.pos.m_122024_());
                this.connections.add(this.pos.m_122029_().m_7494_());
                break;
            }
            case ASCENDING_WEST: {
                this.connections.add(this.pos.m_122024_().m_7494_());
                this.connections.add(this.pos.m_122029_());
                break;
            }
            case ASCENDING_NORTH: {
                this.connections.add(this.pos.m_122012_().m_7494_());
                this.connections.add(this.pos.m_122019_());
                break;
            }
            case ASCENDING_SOUTH: {
                this.connections.add(this.pos.m_122012_());
                this.connections.add(this.pos.m_122019_().m_7494_());
                break;
            }
            case SOUTH_EAST: {
                this.connections.add(this.pos.m_122029_());
                this.connections.add(this.pos.m_122019_());
                break;
            }
            case SOUTH_WEST: {
                this.connections.add(this.pos.m_122024_());
                this.connections.add(this.pos.m_122019_());
                break;
            }
            case NORTH_WEST: {
                this.connections.add(this.pos.m_122024_());
                this.connections.add(this.pos.m_122012_());
                break;
            }
            case NORTH_EAST: {
                this.connections.add(this.pos.m_122029_());
                this.connections.add(this.pos.m_122012_());
            }
        }
    }

    private void removeSoftConnections() {
        for (int i = 0; i < this.connections.size(); ++i) {
            JSRailState JSRailState2 = this.getRail(this.connections.get(i));
            if (JSRailState2 != null && JSRailState2.connectsTo(this)) {
                this.connections.set(i, JSRailState2.pos);
                continue;
            }
            this.connections.remove(i--);
        }
    }

    private boolean hasRail(BlockPos pos) {
        return TourRailBlock.isRail(this.level, pos) || TourRailBlock.isRail(this.level, pos.m_7494_()) || TourRailBlock.isRail(this.level, pos.m_7495_());
    }

    @Nullable
    private JSRailState getRail(BlockPos pos) {
        BlockState blockState = this.level.m_8055_(pos);
        if (TourRailBlock.isRail(blockState)) {
            return new JSRailState(this.level, pos, blockState);
        }
        BlockPos blockPos = pos.m_7494_();
        blockState = this.level.m_8055_(blockPos);
        if (TourRailBlock.isRail(blockState)) {
            return new JSRailState(this.level, blockPos, blockState);
        }
        blockPos = pos.m_7495_();
        blockState = this.level.m_8055_(blockPos);
        return TourRailBlock.isRail(blockState) ? new JSRailState(this.level, blockPos, blockState) : null;
    }

    private boolean connectsTo(JSRailState state) {
        return this.hasConnection(state.pos);
    }

    private boolean hasConnection(BlockPos pos) {
        for (BlockPos connection : this.connections) {
            BlockPos blockPos = connection;
            if (blockPos.m_123341_() != pos.m_123341_() || blockPos.m_123343_() != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    protected int countPotentialConnections() {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.hasRail(this.pos.m_121945_(direction))) continue;
            ++i;
        }
        return i;
    }

    private boolean canConnectTo(JSRailState state) {
        return this.connectsTo(state) || this.connections.size() != 2;
    }

    private void connectTo(JSRailState state) {
        this.connections.add(state.pos);
        BlockPos blockPos = this.pos.m_122012_();
        BlockPos blockPos2 = this.pos.m_122019_();
        BlockPos blockPos3 = this.pos.m_122024_();
        BlockPos blockPos4 = this.pos.m_122029_();
        boolean bl = this.hasConnection(blockPos);
        boolean bl2 = this.hasConnection(blockPos2);
        boolean bl3 = this.hasConnection(blockPos3);
        boolean bl4 = this.hasConnection(blockPos4);
        RailShape railShape = null;
        if (bl || bl2) {
            railShape = RailShape.NORTH_SOUTH;
        }
        if (bl3 || bl4) {
            railShape = RailShape.EAST_WEST;
        }
        if (!this.isStraight) {
            if (bl2 && bl4 && !bl && !bl3) {
                railShape = RailShape.SOUTH_EAST;
            }
            if (bl2 && bl3 && !bl && !bl4) {
                railShape = RailShape.SOUTH_WEST;
            }
            if (bl && bl3 && !bl2 && !bl4) {
                railShape = RailShape.NORTH_WEST;
            }
            if (bl && bl4 && !bl2 && !bl3) {
                railShape = RailShape.NORTH_EAST;
            }
        }
        if (railShape == RailShape.NORTH_SOUTH) {
            if (TourRailBlock.isRail(this.level, blockPos.m_7494_())) {
                railShape = RailShape.ASCENDING_NORTH;
            }
            if (TourRailBlock.isRail(this.level, blockPos2.m_7494_())) {
                railShape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railShape == RailShape.EAST_WEST) {
            if (TourRailBlock.isRail(this.level, blockPos4.m_7494_())) {
                railShape = RailShape.ASCENDING_EAST;
            }
            if (TourRailBlock.isRail(this.level, blockPos3.m_7494_())) {
                railShape = RailShape.ASCENDING_WEST;
            }
        }
        if (railShape == null) {
            railShape = RailShape.NORTH_SOUTH;
        }
        this.state = (BlockState)this.state.m_61124_(this.block.getShapeProperty(), (Comparable)railShape);
        this.level.m_7731_(this.pos, this.state, 3);
    }

    private boolean hasNeighborRail(BlockPos pos) {
        JSRailState JSRailState2 = this.getRail(pos);
        if (JSRailState2 == null) {
            return false;
        }
        JSRailState2.removeSoftConnections();
        return JSRailState2.canConnectTo(this);
    }

    public JSRailState place(boolean powered, boolean alwaysPlace, RailShape shape) {
        boolean bl10;
        boolean bl6;
        BlockPos blockPos = this.pos.m_122012_();
        BlockPos blockPos2 = this.pos.m_122019_();
        BlockPos blockPos3 = this.pos.m_122024_();
        BlockPos blockPos4 = this.pos.m_122029_();
        boolean bl = this.hasNeighborRail(blockPos);
        boolean bl2 = this.hasNeighborRail(blockPos2);
        boolean bl3 = this.hasNeighborRail(blockPos3);
        boolean bl4 = this.hasNeighborRail(blockPos4);
        RailShape railShape = null;
        boolean bl5 = bl || bl2;
        boolean bl7 = bl6 = bl3 || bl4;
        if (bl5 && !bl6) {
            railShape = RailShape.NORTH_SOUTH;
        }
        if (bl6 && !bl5) {
            railShape = RailShape.EAST_WEST;
        }
        boolean bl72 = bl2 && bl4;
        boolean bl8 = bl2 && bl3;
        boolean bl9 = bl && bl4;
        boolean bl11 = bl10 = bl && bl3;
        if (!this.isStraight) {
            if (bl72 && !bl && !bl3) {
                railShape = RailShape.SOUTH_EAST;
            }
            if (bl8 && !bl && !bl4) {
                railShape = RailShape.SOUTH_WEST;
            }
            if (bl10 && !bl2 && !bl4) {
                railShape = RailShape.NORTH_WEST;
            }
            if (bl9 && !bl2 && !bl3) {
                railShape = RailShape.NORTH_EAST;
            }
        }
        if (railShape == null) {
            if (bl5 && bl6) {
                railShape = shape;
            } else if (bl5) {
                railShape = RailShape.NORTH_SOUTH;
            } else if (bl6) {
                railShape = RailShape.EAST_WEST;
            }
            if (!this.isStraight) {
                if (powered) {
                    if (bl72) {
                        railShape = RailShape.SOUTH_EAST;
                    }
                    if (bl8) {
                        railShape = RailShape.SOUTH_WEST;
                    }
                    if (bl9) {
                        railShape = RailShape.NORTH_EAST;
                    }
                    if (bl10) {
                        railShape = RailShape.NORTH_WEST;
                    }
                } else {
                    if (bl10) {
                        railShape = RailShape.NORTH_WEST;
                    }
                    if (bl9) {
                        railShape = RailShape.NORTH_EAST;
                    }
                    if (bl8) {
                        railShape = RailShape.SOUTH_WEST;
                    }
                    if (bl72) {
                        railShape = RailShape.SOUTH_EAST;
                    }
                }
            }
        }
        if (railShape == RailShape.NORTH_SOUTH) {
            if (TourRailBlock.isRail(this.level, blockPos.m_7494_())) {
                railShape = RailShape.ASCENDING_NORTH;
            }
            if (TourRailBlock.isRail(this.level, blockPos2.m_7494_())) {
                railShape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railShape == RailShape.EAST_WEST) {
            if (TourRailBlock.isRail(this.level, blockPos4.m_7494_())) {
                railShape = RailShape.ASCENDING_EAST;
            }
            if (TourRailBlock.isRail(this.level, blockPos3.m_7494_())) {
                railShape = RailShape.ASCENDING_WEST;
            }
        }
        if (railShape == null) {
            railShape = shape;
        }
        this.updateConnections(railShape);
        this.state = (BlockState)this.state.m_61124_(this.block.getShapeProperty(), (Comparable)railShape);
        if (alwaysPlace || this.level.m_8055_(this.pos) != this.state) {
            this.level.m_7731_(this.pos, this.state, 3);
            for (BlockPos connection : this.connections) {
                JSRailState JSRailState2 = this.getRail(connection);
                if (JSRailState2 == null) continue;
                JSRailState2.removeSoftConnections();
                if (!JSRailState2.canConnectTo(this)) continue;
                JSRailState2.connectTo(this);
            }
        }
        return this;
    }

    public BlockState getState() {
        return this.state;
    }

    public List<BlockPos> getConnections() {
        return this.connections;
    }
}

