/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.world.feature;

import java.util.List;
import java.util.OptionalInt;
import jp.jurassicsaga.server.base.world.feature.JSFeatures;
import jp.jurassicsaga.server.v1.world.feature.features.JSSimpleBlockFeature;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class JSV2ConfiguredFeatures {
    private static BootstapContext<ConfiguredFeature<?, ?>> currentContext;
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALE;
    public static final ResourceKey<ConfiguredFeature<?, ?>> RHYOLITE;
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOG_WOOD;
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_DOG_WOOD;
    public static final ResourceKey<ConfiguredFeature<?, ?>> ELEPHANT_GRASS;

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        currentContext = context;
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.f_144266_);
        List<OreConfiguration.TargetBlockState> shaleTargets = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceable, (BlockState)((Block)JSV2Blocks.SHALE.BLOCK.get()).m_49966_()));
        context.m_255272_(SHALE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(shaleTargets, 33)));
        List<OreConfiguration.TargetBlockState> rhyoliteTargets = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceable, (BlockState)((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).m_49966_()));
        context.m_255272_(RHYOLITE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(rhyoliteTargets, 33)));
        JSV2ConfiguredFeatures.register(DOG_WOOD, Feature.f_65760_, JSV2ConfiguredFeatures.createDogWood().m_68251_());
        JSV2ConfiguredFeatures.register(FANCY_DOG_WOOD, Feature.f_65760_, JSV2ConfiguredFeatures.createFancyDogWood().m_68251_());
        JSV2ConfiguredFeatures.registerSimplePlant(ELEPHANT_GRASS, 64, 10, 7, (Block)JSV2Blocks.ELEPHANT_GRASS.get());
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block logBlock, Block leavesBlock, int baseHeight, int heightRandA, int heightRandB, int radius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)logBlock), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leavesBlock), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)radius), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createDogWood() {
        return JSV2ConfiguredFeatures.createStraightBlobTree((Block)JSV2Blocks.DOG_WOOD.LOG.get(), (Block)JSV2Blocks.DOG_WOOD.LEAVES.get(), 4, 2, 0, 2).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyDogWood() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV2Blocks.DOG_WOOD.LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(3, 5, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV2Blocks.DOG_WOOD.LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("jurassicsaga", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        currentContext.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static void registerSimplePlant(ResourceKey<ConfiguredFeature<?, ?>> featureResourceKey, int tries, int xzSpread, int ySpread, Block block) {
        JSSimpleBlockFeature feature = (JSSimpleBlockFeature)((Object)JSFeatures.SIMPLE_BLOCK.get());
        JSV2ConfiguredFeatures.register(featureResourceKey, Feature.f_65763_, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.f_190393_}))));
    }

    static {
        SHALE = JSV2ConfiguredFeatures.registerKey("shale");
        RHYOLITE = JSV2ConfiguredFeatures.registerKey("rhyolite");
        DOG_WOOD = JSV2ConfiguredFeatures.registerKey("dog_wood");
        FANCY_DOG_WOOD = JSV2ConfiguredFeatures.registerKey("fancy_dog_wood");
        ELEPHANT_GRASS = JSV2ConfiguredFeatures.registerKey("elephant_grass");
    }
}

