/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v4.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CorythosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class CorythosaurusAnimal
extends AbstractJSAnimal<CorythosaurusEntity> {
    public CorythosaurusAnimal() {
        super("corythosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<CorythosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.25f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<CorythosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<CorythosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.4f, 0.7f});
        miscProperties.setGuidebookOffset(new Vec2(-1.2f, 0.0f), new Vec2(0.2f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_4);
        miscProperties.setGuideBookDescription("Corythosaurus is a genus of hadrosaurid \"duck-billed\" dinosaur from the Late Cretaceous period, about 77\u201375.7 million years ago, in what is now western North America.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Corythosaurus casuarius");
        miscProperties.setAdvancementTitle("Watch Out For Corinthosaurus");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<CorythosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class, SpinosaurusEntity.class);
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<CorythosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(13405763, 3682342);
        itemProperties.setSpawnEggColorsMale(13541962, 3682342);
        itemProperties.disableMeat();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<CorythosaurusEntity> attributes, EntityBaseProperties<CorythosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(35.0);
        base.setRenderScale((double)1.47f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        base.setTurnSmoothRate((double)0.4f);
        attributes.setPersistent();
        attributes.setEntityFactory(CorythosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions((double)2.1f, 3.5);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(18.0));
        attributes.setWaterEfficiency(1.0);
        attributes.setSwimmingSpeedMultiplier((double)1.3f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

