/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.azure.azurelib.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.class_2318;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class AzBlockEntityModelRenderer<T extends class_2586>
extends AzModelRenderer<Long, T> {
    protected final AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline;

    public AzBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<Long, T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
        this.blockEntityRendererPipeline = blockEntityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        class_2586 entity = (class_2586)context.animatable();
        class_4587 poseStack = context.poseStack();
        if (!isReRender) {
            poseStack.method_22904(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(entity), poseStack);
            AzBlockAnimator<T> animator = this.blockEntityRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, entity, context.partialTick());
            }
        }
        this.blockEntityRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        class_2960 textureLocation = this.blockEntityRendererPipeline.config().textureLocation(context.currentEntity(), entity);
        RenderSystem.setShaderTexture((int)0, (class_2960)textureLocation);
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<Long, T> context, AzBone bone, boolean isReRender) {
        class_4588 buffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_2586 entity = (class_2586)context.animatable();
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, class_243.field_1353.method_46409()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)entity.method_11016().method_10263(), (float)entity.method_11016().method_10264(), (float)entity.method_11016().method_10260())));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected class_2350 getFacing(T block) {
        class_2680 blockState = block.method_11010();
        if (blockState.method_28498((class_2769)class_2383.field_11177)) {
            return (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        }
        if (blockState.method_28498((class_2769)class_2318.field_10927)) {
            return (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        }
        return class_2350.field_11043;
    }

    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        switch (facing) {
            case field_11035: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11043: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(0.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                poseStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
            }
        }
    }
}

