/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.entity;

import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.render.entity.AzEntityRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzEntityRendererConfig<T extends class_1297>
extends AzRendererConfig<UUID, T> {
    private final Function<T, Float> deathMaxRotationProvider;
    private final Function<T, Float> shadowRadius;

    private AzEntityRendererConfig(Supplier<AzAnimator<UUID, T>> animatorProvider, Function<T, Float> deathMaxRotationProvider, Function<T, Float> shadowRadius, Function<T, class_1921> renderTypeFunction, Function<T, class_2960> modelLocationProvider, List<AzRenderLayer<UUID, T>> renderLayers, Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> preRenderEntry, Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> renderEntry, Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> postRenderEntry, Function<T, class_2960> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth, BiFunction<AzRendererPipeline<UUID, T>, AzLayerRenderer<UUID, T>, AzModelRenderer<UUID, T>> modelRendererProvider, Function<AzRendererPipeline<UUID, T>, AzRendererPipelineContext<UUID, T>> pipelineContextFunction, Function<AzBone, class_2960> boneTextureOverrideProvider, Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
        super(animatorProvider, (a, b) -> (class_2960)modelLocationProvider.apply(b), modelRendererProvider, pipelineContextFunction, (a, b) -> (class_1921)renderTypeFunction.apply(b), renderLayers, preRenderEntry, renderEntry, postRenderEntry, (a, b) -> (class_2960)textureLocationProvider.apply(b), alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.deathMaxRotationProvider = deathMaxRotationProvider;
        this.shadowRadius = shadowRadius;
    }

    public float getDeathMaxRotation(T entity) {
        return this.deathMaxRotationProvider.apply(entity).floatValue();
    }

    public float shadowRadius(T entity) {
        return this.shadowRadius.apply(entity).floatValue();
    }

    public static <T extends class_1297> Builder<T> builder(class_2960 modelLocation, class_2960 textureLocation) {
        return new Builder<class_1297>($ -> modelLocation, $ -> textureLocation);
    }

    public static <T extends class_1297> Builder<T> builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
        return new Builder<T>(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder<T extends class_1297>
    extends AzRendererConfig.Builder<UUID, T> {
        private Function<T, Float> deathMaxRotationProvider;
        protected Function<T, Float> shadowRadius;

        public Builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
            super((class_1297 a, T b) -> (class_2960)modelLocationProvider.apply(b), (class_1297 a, T b) -> (class_2960)textureLocationProvider.apply(b));
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzEntityModelRenderer((AzEntityRendererPipeline)entityRendererPipeline, layer);
            this.pipelineContextFunction = AzEntityRendererPipelineContext::new;
            this.renderTypeProvider = (a, b) -> class_1921.method_23576((class_2960)((class_2960)textureLocationProvider.apply(b)));
            this.deathMaxRotationProvider = $ -> Float.valueOf(90.0f);
            this.shadowRadius = $ -> Float.valueOf(0.0f);
        }

        public Builder<T> setBoneRenderTypeOverrideProvider(Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder<T> setBoneTextureOverrideProvider(Function<AzBone, class_2960> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder<T> setModelRenderer(BiFunction<AzRendererPipeline<UUID, T>, AzLayerRenderer<UUID, T>, AzModelRenderer<UUID, T>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder<T> setPipelineContext(Function<AzRendererPipeline<UUID, T>, AzRendererPipelineContext<UUID, T>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        public Builder<T> addRenderLayer(AzRenderLayer<UUID, T> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder<T> setRenderType(class_1921 renderType) {
            this.renderTypeProvider = (a, b) -> renderType;
            return this;
        }

        public Builder<T> setRenderType(Function<T, class_1921> renderTypeProvider) {
            this.renderTypeProvider = (a, b) -> (class_1921)renderTypeProvider.apply(b);
            return this;
        }

        public Builder<T> setRenderType(BiFunction<class_1297, T, class_1921> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder<T> setRenderEntry(Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<UUID, T>, AzRendererPipelineContext<UUID, T>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<UUID, T>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder<T> setDeathMaxRotation(float angle) {
            this.deathMaxRotationProvider = $ -> Float.valueOf(angle);
            return this;
        }

        public Builder<T> setAlpha(Function<T, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder<T> setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder<T> setScale(Function<T, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder<T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder<T> setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder<T> setDeathMaxRotation(Function<T, Float> deathMaxRotationProvider) {
            this.deathMaxRotationProvider = deathMaxRotationProvider;
            return this;
        }

        public Builder<T> setShadowRadius(Function<T, Float> shadowRadiusFunction) {
            this.shadowRadius = shadowRadiusFunction;
            return this;
        }

        public Builder<T> setShadowRadius(float shadowRadius) {
            this.shadowRadius = $ -> Float.valueOf(shadowRadius);
            return this;
        }

        public AzEntityRendererConfig<T> build() {
            AzRendererConfig baseConfig = super.build();
            return new AzEntityRendererConfig<class_1297>(baseConfig::createAnimator, this.deathMaxRotationProvider, this.shadowRadius, baseConfig::getRenderType, baseConfig::modelLocation, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

