/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity.vehicle;

import java.util.Optional;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.animation.AzAnimatorConfig;
import mod.azure.azurelib.animation.controller.AzAnimationController;
import mod.azure.azurelib.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.render.entity.AzEntityRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererConfig;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5617;
import org.jetbrains.annotations.NotNull;

public class VehicleRenderer<T extends JSVehicleEntity>
extends AzEntityRenderer<T> {
    protected String vehicleName;

    public VehicleRenderer(class_5617.class_5618 renderManager, String vehicleName) {
        super(AzEntityRendererConfig.builder((class_2960)new class_2960("jurassicsaga", "geo/vehicle/" + vehicleName + ".geo.json"), (class_2960)new class_2960("jurassicsaga", "textures/entity/vehicle/" + vehicleName + ".png")).setAlpha(1.0f).setRenderType(a -> class_1921.method_23580((class_2960)new class_2960("jurassicsaga", "textures/entity/vehicle/" + vehicleName + ".png"))).setAnimatorProvider(() -> new Animator(vehicleName)).build(), renderManager);
        this.vehicleName = vehicleName;
    }

    public VehicleRenderer(AzEntityRendererConfig<T> config, class_5617.class_5618 context) {
        super(config, context);
    }

    public static class Animator<T extends JSVehicleEntity>
    extends AzEntityAnimator<T> {
        private final class_2960 loc;

        public Animator(String vehicleName) {
            super(AzAnimatorConfig.builder().build());
            this.loc = new class_2960("jurassicsaga", "animations/vehicle/" + vehicleName + ".animation.json");
        }

        public void registerControllers(AzAnimationControllerContainer<T> azAnimationControllerContainer) {
            azAnimationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").build(), new AzAnimationController[0]);
        }

        public void setCustomAnimations(JSVehicleEntity animatable, float partialTicks) {
            double forwardZ;
            AzBakedModel bakedModel = this.context().boneCache().getBakedModel();
            float fps = Math.max(1, class_310.method_1551().method_47599());
            float dt = 30.0f / fps;
            float t = 1.0f - (float)Math.exp(-dt);
            t *= 1.0f + partialTicks * 0.5f;
            double dx = animatable.method_23317() - animatable.field_6014;
            double dz = animatable.method_23321() - animatable.field_5969;
            float yawRad = animatable.method_36454() * ((float)Math.PI / 180);
            double forwardX = -Math.sin(yawRad);
            double forwardMovement = dx * forwardX + dz * (forwardZ = Math.cos(yawRad));
            if (Math.abs(forwardMovement) > 1.0E-5) {
                float deltaRotation = (float)(forwardMovement * (double)t);
                animatable.rearWheelRot -= deltaRotation;
                animatable.frontLeftWheelRot -= deltaRotation;
                animatable.frontRightWheelRot -= deltaRotation;
            }
            Optional rearAxle = bakedModel.getBone("rodRear");
            rearAxle.ifPresent(azBone -> azBone.setRotX(animatable.rearWheelRot));
            Optional fl = bakedModel.getBone("wheelFrontLeft");
            fl.ifPresent(azBone -> azBone.setRotX(animatable.frontLeftWheelRot));
            Optional fr = bakedModel.getBone("wheelFrontRight");
            fr.ifPresent(azBone -> azBone.setRotX(animatable.frontRightWheelRot));
        }

        @NotNull
        public class_2960 getAnimationLocation(JSVehicleEntity block) {
            return this.loc;
        }
    }
}

