/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.layer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.locator.ResourceLocator;

public class LuxLayer
implements AzRenderLayer<UUID, SmartAnimalBase> {
    public static final Map<UUID, Float> previousBrightness = new HashMap<UUID, Float>();

    public void preRender(AzRendererPipelineContext<UUID, SmartAnimalBase> azRendererPipelineContext) {
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context) {
        Object object = context.animatable();
        if (object instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)((Object)object);
            if (base.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                return;
            }
            if (!base.getModules().getGeneticModule().getGeneData().hasGene(JSGenetics.LUX)) {
                return;
            }
            float brightness = this.getLerpedBrightness(base);
            if (brightness >= 16.0f) {
                return;
            }
            ResourceLocator resourceLocator = base.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator();
            if (resourceLocator instanceof JSAnimalBaseLocator) {
                JSAnimalBaseLocator locator = (JSAnimalBaseLocator)resourceLocator;
                AzRendererPipeline renderPipeline = context.rendererPipeline();
                class_2960 textureLocation = locator.getLuxLocation(base);
                if (textureLocation == null) {
                    return;
                }
                class_1921 renderType = class_1921.method_42600((class_2960)textureLocation);
                class_1921 prevRenderType = context.renderType();
                int prevPackedLight = context.packedLight();
                class_4588 prevVertexConsumer = context.vertexConsumer();
                context.setRenderType(renderType);
                context.setPackedLight(0xF00000);
                context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
                int color = this.getHueShiftColor(base.getModules().getGeneticModule().getGeneData().getGeneSeed(), brightness);
                int a = color >>> 24 & 0xFF;
                int r = color >>> 16 & 0xFF;
                int g = color >>> 8 & 0xFF;
                int b = color & 0xFF;
                context.setRed((float)r / 255.0f);
                context.setGreen((float)g / 255.0f);
                context.setBlue((float)b / 255.0f);
                context.setAlpha((float)a / 255.0f);
                renderPipeline.reRender(context);
                context.setRenderType(prevRenderType);
                context.setPackedLight(prevPackedLight);
                context.setVertexConsumer(prevVertexConsumer);
            }
        }
    }

    public float getLerpedBrightness(JSAnimalBase base) {
        if (base.isStaticCreature()) {
            return 16.0f;
        }
        UUID id = base.method_5667();
        int sky = base.method_37908().method_8314(class_1944.field_9284, base.method_24515());
        int block = base.method_37908().method_8314(class_1944.field_9282, base.method_24515());
        float light = Math.max(sky, block);
        float target = 16.0f - light * 1.0666667f;
        float previous = previousBrightness.getOrDefault(id, Float.valueOf(target)).floatValue();
        float lerped = class_3532.method_16439((float)0.1f, (float)previous, (float)target);
        previousBrightness.put(id, Float.valueOf(lerped));
        return lerped;
    }

    public int getHueShiftColor(int seed, float brightness) {
        Random random = new Random(seed);
        float t = class_3532.method_15363((float)(brightness / 16.0f), (float)0.0f, (float)1.0f);
        float baseHue = random.nextFloat();
        float hue = (baseHue + t * 0.15f) % 1.0f;
        float saturation = 0.8f;
        float value = 1.0f;
        int rgb = Color.HSBtoRGB(hue, saturation, value);
        int alpha = class_3532.method_15340((int)Math.round((1.0f - t) * 255.0f), (int)0, (int)255);
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public void renderForBone(AzRendererPipelineContext<UUID, SmartAnimalBase> azRendererPipelineContext, AzBone azBone) {
    }
}

