/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.animation;

import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.client.v1.animation.JSAnimationData;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSClientAnimator
extends TravelersClientAnimator {
    protected TravelersAnimationData createData() {
        return new JSAnimationData();
    }

    protected void applyTilt(SmartAnimalBase e, float rotSpeed, float maxPitch, float rollIncrement, float maxRoll, float partialTick, Supplier<Boolean> booleanSupplier, List<TravelersBoneState> bones) {
        boolean dirChanged;
        JSAnimationData data = (JSAnimationData)this.boneOffsetCache.computeIfAbsent(e.method_5845(), id -> this.createData());
        class_243 vel = e.method_18798();
        boolean flying = booleanSupplier.get();
        class_243 prev = data.prevVel != null ? data.prevVel : class_243.field_1353;
        data.prevVel = vel;
        class_243 delta = vel.method_1020(prev);
        boolean bl = dirChanged = delta.method_37268() > 1.0E-6;
        if (flying && dirChanged) {
            float yawPrev;
            float yawNow = (float)Math.atan2(vel.field_1352, vel.field_1350);
            float yawDiff = class_3532.method_15393((float)((yawNow - (yawPrev = (float)Math.atan2(prev.field_1352, prev.field_1350))) * 57.295776f)) * ((float)Math.PI / 180);
            if (Math.abs(yawDiff) < 0.002f) {
                yawDiff = 0.0f;
            }
            float impulse = class_3532.method_15363((float)(yawDiff * 1.1f), (float)(-rollIncrement * 2.5f), (float)(rollIncrement * 2.5f));
            data.tiltRoll += impulse * 0.7f;
            data.tiltRoll = class_3532.method_15363((float)data.tiltRoll, (float)(-maxRoll), (float)maxRoll);
        }
        float pitchTarget = 0.0f;
        if (flying && vel.method_1027() > 1.0E-8) {
            float speed = (float)Math.max(1.0E-8, vel.method_1033());
            float vy = (float)(-vel.field_1351 / (double)speed);
            pitchTarget = class_3532.method_15363((float)(vy * 0.45f), (float)(-maxPitch), (float)maxPitch);
        }
        float fps = Math.max(1, class_310.method_1551().method_47599());
        float dt = rotSpeed / fps;
        float t = 1.0f - (float)Math.exp(-dt);
        t *= 1.0f + partialTick * 0.5f;
        if (!flying) {
            data.tiltRoll = class_3532.method_16439((float)(t * 0.2f), (float)data.tiltRoll, (float)0.0f);
            pitchTarget = 0.0f;
        } else {
            float decay = (float)Math.pow(0.992f, 60.0f / fps);
            data.tiltRoll *= decay;
        }
        int n = Math.max(1, bones.size());
        for (int i = 0; i < n; ++i) {
            TravelersBoneState b = bones.get(i);
            float w = (float)Math.pow(((float)i + 1.0f) / (float)n, 1.15f);
            float targetX = -pitchTarget * w;
            float targetZ = data.tiltRoll * (1.4f * w);
            float smoothT = 1.0f - (float)Math.exp(-rotSpeed * (1.0f + partialTick * 0.75f) / fps);
            b.angleX += (targetX - b.angleX) * smoothT * 0.4f;
            b.angleZ += (targetZ - b.angleZ) * smoothT * 0.45f;
        }
    }
}

