/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.fabric.server.world;

import java.util.function.Predicate;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.world.feature.JSV1PlacedFeatures;
import jp.jurassicsaga.server.v2.world.feature.JSV2PlacedFeatures;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class JSBiomeModifiers {
    public static void init() {
        JSBiomeModifiers.initV1();
    }

    private static void initV1() {
        JSBiomeModifiers.registerVegitation(JSV1PlacedFeatures.WEST_INDIAN_LILAC, class_1972.field_34470, class_1972.field_35116);
        JSBiomeModifiers.registerVegitation(JSV1PlacedFeatures.SWISS_CHEESE_PLANT, class_1972.field_35118);
        JSBiomeModifiers.registerVegitation(JSV1PlacedFeatures.HELICONIA, class_1972.field_9417, class_1972.field_9440);
        JSBiomeModifiers.registerVegitation(JSV1PlacedFeatures.ROYAL_FERN, (class_6862<class_1959>)class_6908.field_36495);
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            JSMiscProperties misc = animal.getAnimalAttributes().getMiscProperties();
            if (misc.getSpawnPredicate() == null) continue;
            class_1317.method_20637((class_1299)((class_1299)animal.getEntityType().get()), (class_1317.class_1319)misc.getSpawnPlacementType(), (class_2902.class_2903)misc.getSpawnHeightMap(), misc.getSpawnPredicate());
        }
        for (Era era : Era.values()) {
            if (era.isHasMarineOre()) {
                BiomeModifications.addFeature((Predicate)BiomeSelectors.all(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("jurassicsaga", era.getEraName() + "_marine_placed")));
            }
            if (!era.isHasFossilOre()) continue;
            BiomeModifications.addFeature((Predicate)BiomeSelectors.all(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("jurassicsaga", era.getEraName() + "_fossil_placed")));
        }
        BiomeModifications.addFeature((Predicate)BiomeSelectors.all(), (class_2893.class_2895)class_2893.class_2895.field_13176, JSV2PlacedFeatures.SHALE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.all(), (class_2893.class_2895)class_2893.class_2895.field_13176, JSV2PlacedFeatures.RHYOLITE);
    }

    @SafeVarargs
    private static void registerVegitation(class_5321<class_6796> featureResourceKey, class_5321<class_1959> ... biomeResourceKeys) {
        BiomeModifications.addFeature(biomes -> {
            for (class_5321 biomeResourceKey : biomeResourceKeys) {
                if (biomeResourceKey != biomes.getBiomeKey()) continue;
                return true;
            }
            return false;
        }, (class_2893.class_2895)class_2893.class_2895.field_13178, featureResourceKey);
    }

    private static void registerVegitation(class_5321<class_6796> featureResourceKey, class_6862<class_1959> key) {
        BiomeModifications.addFeature(biomes -> biomes.hasTag(key), (class_2893.class_2895)class_2893.class_2895.field_13178, featureResourceKey);
    }
}

