/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.function.BiConsumer;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.mixin.GameRulesIntAccessor;
import net.minecraft.class_1928;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class JSBoundedIntRule
extends class_1928.class_4312 {
    private static final Logger LOGGER = JSConstants.LOG;
    private final int minimumValue;
    private final int maximumValue;

    public JSBoundedIntRule(class_1928.class_4314<class_1928.class_4312> type, int initialValue, int minimumValue, int maximumValue) {
        super(type, initialValue);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    protected void method_20777(@NotNull String value) {
        int i = JSBoundedIntRule.safeParse(value);
        if (this.minimumValue > i || this.maximumValue < i) {
            LOGGER.warn("Failed to parse integer {}. Was out of bounds {} - {}", new Object[]{value, this.minimumValue, this.maximumValue});
            return;
        }
        ((GameRulesIntAccessor)((Object)this)).setValue(i);
    }

    public static class_1928.class_4314<class_1928.class_4312> create(int defaultValue, int minimumValue, int maximumValue, @Nullable BiConsumer<MinecraftServer, class_1928.class_4312> changedCallback) {
        return new class_1928.class_4314(() -> IntegerArgumentType.integer((int)minimumValue, (int)maximumValue), type -> new JSBoundedIntRule((class_1928.class_4314<class_1928.class_4312>)type, defaultValue, minimumValue, maximumValue), changedCallback, class_1928.class_4311::method_27330);
    }

    public boolean method_27332(@NotNull String input) {
        try {
            int value = Integer.parseInt(input);
            if (this.minimumValue > value || this.maximumValue < value) {
                return false;
            }
            ((GameRulesIntAccessor)((Object)this)).setValue(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_1928.class_4312 method_27333() {
        return new JSBoundedIntRule((class_1928.class_4314<class_1928.class_4312>)this.field_19417, ((GameRulesIntAccessor)((Object)this)).getValue(), this.minimumValue, this.maximumValue);
    }

    private static int safeParse(String input) {
        if (!input.isEmpty()) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException var2) {
                LOGGER.warn("Failed to parse integer {}", (Object)input);
            }
        }
        return 0;
    }
}

