/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1334;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersFlyingMoveControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAvianBase
extends JSAnimalBase {
    public static final class_2940<Boolean> FLYING = class_2945.method_12791(JSAvianBase.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DIVING = class_2945.method_12791(JSAvianBase.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> WANTS_TO_LAND = class_2945.method_12791(JSAvianBase.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> FLAPPING = class_2945.method_12791(JSAvianBase.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> GLIDING = class_2945.method_12791(JSAvianBase.class, (class_2941)class_2943.field_13323);
    private JSFlyingNavigation flyingPathNavigation;
    private JSGroundNavigation groundPathNavigation;
    protected final TravelersFlyingMoveControl flyingMoveControl;
    protected final TravelersMoveControl animalMoveControl = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
    protected float stamina = 1.0f;
    protected float staminaDrainRate = 0.0015f;
    protected float staminaRegenRate = 0.0025f;
    private int takeoffCooldown = 0;
    private int landingCooldown = 0;

    public JSAvianBase(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.flyingMoveControl = new TravelersFlyingMoveControl((SmartAnimalBase)this, this.getAnimal(), this.hoversInPlace());
        this.moveController = this.animalMoveControl;
        this.field_6206 = new JSLookControl(this);
    }

    public JSFlyingNavigation getFlyingPathNavigation() {
        if (this.flyingPathNavigation == null) {
            this.flyingPathNavigation = new JSFlyingNavigation(this, this.method_37908());
        }
        return this.flyingPathNavigation;
    }

    public JSGroundNavigation getGroundPathNavigation() {
        if (this.groundPathNavigation == null) {
            this.groundPathNavigation = new JSGroundNavigation(this, this.method_37908());
        }
        return this.groundPathNavigation;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(class_1937 level) {
        return this.getGroundPathNavigation();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(DIVING, (Object)false);
        this.field_6011.method_12784(WANTS_TO_LAND, (Object)true);
        this.field_6011.method_12784(FLAPPING, (Object)false);
        this.field_6011.method_12784(GLIDING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public boolean wantsToLand() {
        return (Boolean)this.field_6011.method_12789(WANTS_TO_LAND);
    }

    public boolean isDiving() {
        return (Boolean)this.field_6011.method_12789(DIVING);
    }

    public void setDiving(boolean diving) {
        this.field_6011.method_12778(DIVING, (Object)diving);
    }

    @Override
    public void method_6091(@NotNull class_243 travelVector) {
        if (this.isFlying()) {
            if (this.method_5787()) {
                if (this.method_5771()) {
                    this.method_5724(0.02f, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021(0.5));
                } else {
                    float f = 0.95f;
                    float speed = this.method_6029();
                    this.method_5724(speed, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_18805((double)0.91f, (double)f, (double)0.91f));
                }
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    @Override
    public float method_6029() {
        return this.isFlying() ? (float)this.method_6127().method_26856(class_5134.field_23720) : super.method_6029();
    }

    protected void method_5623(double y, boolean onGround, @NotNull class_2680 state, @NotNull class_2338 pos) {
        if (!this.isFlying()) {
            super.method_5623(y, onGround, state, pos);
        }
    }

    @Override
    public boolean method_6101() {
        return super.method_6101() && !this.isFlying();
    }

    @Override
    public void method_6043() {
        if (!this.isFlying()) {
            super.method_6043();
        }
    }

    public void method_6100(boolean jumping) {
        if (!this.isFlying()) {
            super.method_6100(jumping);
        }
    }

    @NotNull
    public class_1334 method_5993() {
        return new FlyingJumpControl(this);
    }

    protected boolean hoversInPlace() {
        return false;
    }

    @Override
    public void method_6007() {
        if (this.takeoffCooldown > 0) {
            --this.takeoffCooldown;
        }
        if (this.landingCooldown > 0) {
            --this.landingCooldown;
        }
        this.handleStamina();
        super.method_6007();
        this.method_5875(this.hoversInPlace());
        if (this.isDead() && !this.method_24828()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.075, 0.0));
            return;
        }
        if (this.method_6113() || this.isResting()) {
            if (!this.method_24828() && this.isFlying()) {
                this.field_6011.method_12778(WANTS_TO_LAND, (Object)true);
            } else if (this.isFlying() && this.method_24828()) {
                this.setFlying(false);
            }
            return;
        }
        if (this.disableFlyTransitions() || this.getModules().getMetabolismModule().isThirsty()) {
            if (!this.isFlying()) {
                this.setFlying(true);
            }
            return;
        }
        if (this.method_18798().field_1351 < -10.0 && !this.isFlying() || this.method_5799()) {
            this.setFlying(true);
        }
        if (this.isFlying()) {
            this.handleFlying();
            this.tryLanding();
        } else {
            this.tryTakeoff();
        }
    }

    private void handleStamina() {
        if (this.isFlying()) {
            this.stamina = Math.max(0.0f, this.stamina - this.staminaDrainRate);
            if (this.stamina <= 0.0f) {
                this.field_6011.method_12778(WANTS_TO_LAND, (Object)true);
            }
        } else if (this.method_24828() || this.hasSolidBelow()) {
            this.stamina = Math.min(1.0f, this.stamina + this.staminaRegenRate);
        }
    }

    private void handleFlying() {
        boolean goingUpOrFlat;
        class_243 motion = this.method_18798();
        boolean bl = this.getNavigationController().isDone() ? motion.field_1351 > (double)-0.06f : (goingUpOrFlat = motion.field_1351 >= -0.1);
        if (goingUpOrFlat) {
            this.setFlapping(true);
            this.setGliding(false);
        } else {
            this.setFlapping(false);
            this.setGliding(true);
        }
        if (this.getNavigationController().isDone()) {
            if (motion.field_1351 < 0.0) {
                class_243 forward = this.method_5720().method_1029().method_1021((double)this.method_6029());
                this.method_18799(forward.method_1031(0.0, -0.1, 0.0));
            } else if (!this.hoversInPlace()) {
                this.method_18799(motion.method_1031(0.0, -0.005, 0.0));
            } else {
                this.method_18799(new class_243(motion.field_1352, 0.01, motion.field_1350));
            }
        }
        if (!this.wantsToLand() && this.stamina < 0.5f && this.field_5974.method_43057() < 0.01f) {
            this.field_6011.method_12778(WANTS_TO_LAND, (Object)true);
        }
    }

    public boolean method_5776() {
        return (Boolean)this.field_6011.method_12789(FLAPPING);
    }

    public boolean isGliding() {
        return (Boolean)this.field_6011.method_12789(GLIDING);
    }

    private void setFlapping(boolean val) {
        this.field_6011.method_12778(FLAPPING, (Object)val);
    }

    private void setGliding(boolean val) {
        this.field_6011.method_12778(GLIDING, (Object)val);
    }

    private void tryLanding() {
        if (this.landingCooldown > 0) {
            return;
        }
        if ((this.method_24828() || this.hasSolidBelow()) && this.wantsToLand()) {
            this.setFlying(false);
            this.landingCooldown = 40;
        }
    }

    private void tryTakeoff() {
        if (this.takeoffCooldown > 0) {
            return;
        }
        if (this.stamina > 0.95f && this.field_5974.method_43057() < 0.02f) {
            this.setFlying(true);
            this.takeoffCooldown = 60;
        }
    }

    public void setFlying(boolean flying) {
        if (this.isFlying() == flying) {
            return;
        }
        this.field_6011.method_12778(FLYING, (Object)flying);
        this.field_6011.method_12778(WANTS_TO_LAND, (Object)(!flying ? 1 : 0));
        if (flying) {
            this.moveController = this.flyingMoveControl;
            if (this.getNavigationController() == this.getGroundPathNavigation()) {
                this.getGroundPathNavigation().stop();
                this.getGroundPathNavigation().setFrozen(false);
            }
            this.navigationController = this.getFlyingPathNavigation();
            if (this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, 0.075, 0.0));
            } else {
                class_243 mv = this.method_18798();
                this.method_18799(new class_243(mv.field_1352, 0.0, mv.field_1350));
            }
        } else {
            this.moveController = this.animalMoveControl;
            this.navigationController = this.getGroundPathNavigation();
            this.getFlyingPathNavigation().stop();
            this.method_18799(class_243.field_1353);
            this.takeoffCooldown = 60;
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("js.isFlying", this.isFlying());
        tag.method_10556("js.isLanding", this.wantsToLand());
        tag.method_10548("js.stamina", this.stamina);
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        boolean flying = tag.method_10577("js.isFlying");
        this.field_6011.method_12778(WANTS_TO_LAND, (Object)tag.method_10577("js.isLanding"));
        if (tag.method_10545("js.stamina")) {
            this.stamina = tag.method_10583("js.stamina");
        }
        this.setFlying(flying);
    }

    public boolean disableFlyTransitions() {
        return false;
    }

    public int getDistanceOfGround() {
        return -1;
    }

    private static class FlyingJumpControl
    extends class_1334 {
        private final JSAvianBase base;

        public FlyingJumpControl(JSAvianBase mob) {
            super((class_1308)mob);
            this.base = mob;
        }

        public void method_6233() {
            this.field_6365 = true;
        }

        public void method_6234() {
            if (this.base.isFlying()) {
                if (this.base.field_6282) {
                    this.base.method_6100(false);
                    this.field_6365 = false;
                }
            } else {
                this.base.method_6100(this.field_6365);
                this.field_6365 = false;
            }
        }
    }
}

