/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersSwimNodeEvaluator;
import travelers.util.TravelersUtil;

public class JSAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSAquaticNavigation(JSAnimalBase mob, class_1937 level, boolean allowBreaching) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        if (this.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAnimalBase mob) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 nodeCenter = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_243 pos = mob.method_19538();
        return TravelersUtil.closerThan((class_243)nodeCenter, (class_243)pos, (double)Math.max(0.75, (double)(mob.method_17681() / 2.0f)), (double)Math.max(0.75f, mob.method_17682()));
    }

    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.method_5799();
    }

    protected double getGroundY(class_243 vec) {
        return vec.field_1351;
    }

    protected class_243 getTempMobPos() {
        return new class_243(this.mob.method_23317(), this.mob.method_23323(0.5), this.mob.method_23321());
    }

    public boolean isStableDestination(class_2338 pos) {
        return !this.level.method_8320(pos).method_26216((class_1922)this.level, pos);
    }

    public void setCanFloat(boolean canSwim) {
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

