/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import java.util.Locale;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersFlyingNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersFlyNodeEvaluator;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public class JSFlyingNavigation
extends TravelersFlyingNavigation {
    private final JSAvianBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSFlyingNavigation(JSAvianBase mob, class_1937 level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone() && !this.isLookingForPath) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                class_243 vec3 = this.getTempMobPos();
                class_243 vec31 = this.path.getNextEntityPos((class_1297)this.mob);
                if (vec31.method_1025(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            if (!this.isDone() && !this.isLookingForPath) {
                if (this.path == null) {
                    return;
                }
                class_243 target = this.path.getNextEntityPos((class_1297)this.mob);
                if (this.mob.method_19538().method_24802((class_2374)target, (double)this.maxDistanceToWaypoint)) {
                    if (this.path.isDone()) {
                        this.stop();
                    }
                } else {
                    this.mob.getMoveController().setWantedPosition(target.field_1352, target.field_1351, target.field_1350, 1.0);
                }
            }
        }
    }

    void sendPathFinding(class_1937 level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (TravelersMain.isDebugging()) {
            if (path == null || level.field_9236) {
                return;
            }
            if (TravelersDebug.ENABLED_DEBUGS.contains(mob.getAnimal().getAnimalAttributes().getModId().toLowerCase(Locale.ROOT))) {
                TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)mob, (TravelersBasePacket)new TravelersPathFindingDebug(mob.method_5628(), path, maxDistanceToWaypoint));
            }
        }
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        } else {
            this.checkStuckOnNode();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAvianBase mob, class_243 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 nodePos = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_238 box = mob.method_5829().method_1009(1.0, 1.0, 1.0);
        return box.method_1006(nodePos);
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersFlyNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

