/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1603;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TaskGoal;

public class JSRangedAttackTask
extends JSTaskBase {
    private final class_1603 rangedAttackanimal;
    @Nullable
    private class_1309 target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public JSRangedAttackTask(JSAnimalBase baseAnimal, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        super(baseAnimal);
        class_1603 rangedAttackanimal;
        if (!(baseAnimal instanceof class_1603)) {
            throw new IllegalArgumentException("Can't apply ranged attack task to an non ranged entity");
        }
        this.rangedAttackanimal = rangedAttackanimal = (class_1603)baseAnimal;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.getGoals().add(TaskGoal.MISC);
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isResting() || this.animal.method_6113()) {
            return false;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        class_1309 livingentity = this.animal.method_5968();
        if (livingentity != null && livingentity.method_5805()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueRunning() {
        if (this.target == null) {
            return false;
        }
        if (this.animal.isDead() || this.animal.isResting() || this.animal.method_6113()) {
            return false;
        }
        return this.shouldRun() || this.target.method_5805() && !this.animal.getNavigationController().isDone();
    }

    protected boolean runOnce() {
        return false;
    }

    public void onStart() {
    }

    public void tick() {
        if (this.target instanceof class_1309) {
            double d0 = this.animal.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
            boolean flag = this.animal.method_5985().method_6369((class_1297)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.animal.getNavigationController().stop();
            } else {
                this.animal.getNavigationController().moveTo((class_1297)this.target);
            }
            this.animal.method_5988().method_35111((class_1297)this.target);
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = class_3532.method_15363((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackanimal.method_7105(this.target, f1);
                if (this.runOnce()) {
                    this.checkCooldown = 20;
                    this.stop();
                }
                this.attackTime = class_3532.method_15375((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = class_3532.method_15357((double)class_3532.method_16436((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStop() {
        if (this.target != null) {
            this.animal.method_5988().method_35111((class_1297)this.target);
        }
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }
}

