/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSMateTask
extends JSTaskBase {
    JSAnimalBase target;
    protected int recomputePathTicks = 10;
    private int movingTicks = 0;

    public JSMateTask(JSAnimalBase en) {
        super(en);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead() || this.animal.method_6109() || this.animal.getModules().getMetabolismModule().isGestating() || this.animal.method_5681() || this.animal.getModules().getMetabolismModule().isBreedingInCooldown()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isBreedingEnabled()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (!this.animal.getModules().getMetabolismModule().isBreedingEnabled() || this.animal.getModules().getMetabolismModule().isGestating() || this.animal.getModules().getMetabolismModule().isBreedingInCooldown()) {
            return false;
        }
        if (this.animal.method_5968() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        if (this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.method_6113() || this.animal.isPanicking()) {
            return false;
        }
        this.findMate();
        return this.target != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.method_5968() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        return this.target != null && this.animal.getModules().getMetabolismModule().isBreedingEnabled() && !this.animal.getModules().getMetabolismModule().isGestating() && !this.animal.getModules().getMetabolismModule().isBreedingInCooldown();
    }

    public void onStart() {
        if (this.target == null) {
            this.stop();
        }
        CompletableFuture future = this.animal.getNavigationController().moveTo((class_1297)this.target);
        this.animal.method_5702(class_2183.class_2184.field_9851, this.target.method_19538());
        if (future != null) {
            future.thenAccept(travelersPath -> {
                if (travelersPath != null) {
                    travelersPath.advance();
                }
            });
        }
    }

    public void tick() {
        if (this.target == null || this.animal.getModules().getMetabolismModule().isGestating() || this.target.getModules().getMetabolismModule().isGestating() || this.target.isDead() || this.target.method_6113() || this.target.isPanicking()) {
            this.stop();
            return;
        }
        if (JSTaskUtils.isCloseEnough(this.animal, this.target.method_23312().method_46558(), 2.0f) && !this.animal.getModules().getGeneticModule().isMale()) {
            this.animal.onMate(this.target);
            this.target.onMate(this.animal);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo((class_1297)this.target);
            if (moveTo != null) {
                moveTo.thenAccept(travelersPath -> {
                    if (travelersPath == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        travelersPath.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(20, 25);
        } else if (this.recomputePathTicks > 0) {
            --this.recomputePathTicks;
        }
    }

    public void onStop() {
        this.recomputePathTicks = 10;
    }

    public void findMate() {
        class_238 tracking = this.getTargetSearchArea(this.animal.getTrackingRange());
        boolean isMale = this.animal.getModules().getGeneticModule().isMale();
        List entities = this.animal.method_37908().method_8390(JSAnimalBase.class, tracking, mob -> mob.getAnimal() == this.animal.getAnimal() && this.animal.method_6057((class_1297)mob) && isMale != mob.getModules().getGeneticModule().isMale() && !mob.method_6109() && !mob.isDead() && mob.getModules().getMetabolismModule().isBreedingEnabled() && !mob.isPanicking() && !mob.getModules().getMetabolismModule().isGestating() && !mob.getModules().getMetabolismModule().isBreedingInCooldown());
        this.target = (JSAnimalBase)this.animal.method_37908().method_18468(entities, class_4051.field_18092.method_18418(this.animal.getTrackingRange()), (class_1309)this.animal, this.animal.method_23317(), this.animal.method_23320(), this.animal.method_23321());
    }

    protected class_238 getTargetSearchArea(double targetDistance) {
        return this.animal.method_5829().method_1009(targetDistance, targetDistance, targetDistance);
    }
}

