/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSDefaultRandomPos;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFleeTask
extends JSTaskBase {
    private final int fleeDistance;
    private int ticksToNextPathCalc;
    protected class_1297 currentFleeTarget = null;

    public JSFleeTask(JSAnimalBase baseAnimal, int fleeDistance) {
        super(baseAnimal);
        this.fleeDistance = fleeDistance;
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.setPriority(TaskPriority.VERY_HIGH);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.method_5968() != null) {
            return false;
        }
        if (this.animal.getFleeTarget() == null) {
            class_1657 nearestPlayer;
            class_238 bb = this.animal.method_5829().method_1009((double)this.fleeDistance, (double)this.fleeDistance / 2.0, (double)this.fleeDistance);
            List list = this.level.method_8390(class_1314.class, bb, a -> {
                if (!this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().isScaredOf((class_1309)a)) {
                    return false;
                }
                if (!this.canTargetSeeMe((class_1309)this.animal, (class_1314)a) && !a.method_6510()) {
                    return false;
                }
                if (a instanceof JSAnimalBase) {
                    JSAnimalBase b = (JSAnimalBase)((Object)a);
                    return !b.isDead() && a.method_5805() && !a.method_5779((class_1297)this.animal);
                }
                return a.method_5805() && !a.method_5779((class_1297)this.animal);
            });
            list.stream().min(Comparator.comparingDouble(e -> e.method_5739((class_1297)this.animal))).ifPresent(this.animal::setFleeTarget);
            if (this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().getScaredOf().contains(class_1657.class) && (nearestPlayer = this.level.method_18460((class_1297)this.animal, (double)this.fleeDistance)) != null) {
                this.animal.setFleeTarget((class_1297)nearestPlayer);
            }
        }
        return this.animal.getFleeTarget() != null;
    }

    private boolean canTargetSeeMe(class_1309 target, class_1314 entity) {
        double minDot;
        class_243 toEntity;
        class_243 entityEyes;
        if (target.method_37908() != entity.method_37908()) {
            return false;
        }
        class_243 targetEyes = new class_243(target.method_23317(), target.method_23320(), target.method_23321());
        if (targetEyes.method_1022(entityEyes = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321())) > 64.0) {
            return false;
        }
        class_243 forward = target.method_5720().method_1029();
        double dot = forward.method_1026(toEntity = entityEyes.method_1020(targetEyes).method_1029());
        return dot >= (minDot = Math.cos(Math.toRadians(75.0))) && target.method_37908().method_17742(new class_3959(targetEyes, entityEyes, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)target)).method_17783() == class_239.class_240.field_1333;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.currentFleeTarget = this.animal.getFleeTarget();
        this.animal.getModules().getMetabolismModule().interrupt(20);
        this.animal.setIsPanicking(true);
    }

    public boolean canContinueRunning() {
        JSAnimalBase base;
        class_1297 class_12972;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.currentFleeTarget.method_31481() || (class_12972 = this.currentFleeTarget) instanceof JSAnimalBase && (base = (JSAnimalBase)class_12972).isDead()) {
            return false;
        }
        return this.currentFleeTarget != null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.currentFleeTarget == null) {
            this.stop();
            return;
        }
        if (this.animal.method_5739(this.currentFleeTarget) > this.animal.method_17681() * (float)this.fleeDistance) {
            this.stop();
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.ticksToNextPathCalc <= 0) {
            double angleVariance;
            this.ticksToNextPathCalc = 20 + this.random.nextInt(20);
            class_243 awayDir = this.animal.method_19538().method_1020(this.currentFleeTarget.method_19538()).method_1029();
            double dist = (double)this.fleeDistance * 2.0;
            class_243 wantedPos = this.animal.method_19538().method_1019(awayDir.method_1021(dist));
            class_243 pos = JSDefaultRandomPos.getPosTowards(this.animal, this.fleeDistance * 2, this.fleeDistance, wantedPos, angleVariance = Math.toRadians(30.0));
            if (pos == null) {
                pos = JSDefaultRandomPos.getPosAway(this.animal, this.fleeDistance * 2, this.fleeDistance, this.currentFleeTarget.method_19538());
            }
            if (pos == null) {
                this.ticksToNextPathCalc = 0;
                return;
            }
            CompletableFuture path = this.animal.getNavigationController().moveTo(pos.field_1352, pos.field_1351, pos.field_1350);
            if (path != null) {
                path.thenAccept(jsPath -> {
                    if (jsPath == null) {
                        this.ticksToNextPathCalc += 15;
                    } else {
                        jsPath.advance();
                    }
                });
            } else {
                this.ticksToNextPathCalc += 15;
            }
        }
        if (this.ticksToNextPathCalc > 0) {
            --this.ticksToNextPathCalc;
        }
    }

    public void onStop() {
        this.currentFleeTarget = null;
        this.animal.setFleeTarget(null);
        this.animal.setIsPanicking(false);
    }
}

