/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class JSRandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;
    private static final Random rng = new Random();

    public static class_2338 generateRandomDirection(int radius, int verticalRange) {
        int dx = rng.nextInt(radius * 2 + 1) - radius;
        int dy = rng.nextInt(verticalRange * 2 + 1) - verticalRange;
        int dz = rng.nextInt(radius * 2 + 1) - radius;
        return new class_2338(dx, dy, dz);
    }

    public static class_2338 searchUpDown(class_2338 start, int range, Predicate<class_2338> condition) {
        if (condition.test(start)) {
            return start;
        }
        for (int i = 1; i <= range; ++i) {
            class_2338 up = start.method_10086(i);
            if (condition.test(up)) {
                return up;
            }
            class_2338 down = start.method_10087(i);
            if (!condition.test(down)) continue;
            return down;
        }
        return null;
    }

    @Nullable
    public static class_2338 generateRandomDirectionWithinRadians(int maxHorizontalDifference, int yRange, int baseY, double baseX, double baseZ, double maxAngleDelta) {
        double baseAngle = class_3532.method_15349((double)baseZ, (double)baseX) - 1.5707963267948966;
        double angle = baseAngle + (2.0 * (double)rng.nextFloat() - 1.0) * maxAngleDelta;
        double distance = Math.sqrt(rng.nextDouble()) * (double)class_3532.field_15724 * (double)maxHorizontalDifference;
        double offsetX = -distance * Math.sin(angle);
        double offsetZ = distance * Math.cos(angle);
        if (Math.abs(offsetX) > (double)maxHorizontalDifference || Math.abs(offsetZ) > (double)maxHorizontalDifference) {
            return null;
        }
        int y = baseY + rng.nextInt(2 * yRange + 1) - yRange;
        return class_2338.method_49637((double)offsetX, (double)y, (double)offsetZ);
    }

    public static class_2338 moveUpOutOfSolid(class_2338 pos, int maxY, Predicate<class_2338> isSolid) {
        if (!isSolid.test(pos)) {
            return pos;
        }
        class_2338 current = pos.method_10084();
        while (current.method_10264() < maxY && isSolid.test(current)) {
            current = current.method_10084();
        }
        return current;
    }

    public static class_2338 moveUpToAboveSolid(class_2338 pos, int aboveSolidAmount, int maxY, Predicate<class_2338> isSolid) {
        class_2338 next;
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount must be >= 0, got: " + aboveSolidAmount);
        }
        if (!isSolid.test(pos)) {
            return pos;
        }
        class_2338 base = pos.method_10084();
        while (base.method_10264() < maxY && isSolid.test(base)) {
            base = base.method_10084();
        }
        class_2338 check = base;
        for (int i = 0; i < aboveSolidAmount && check.method_10264() < maxY && !isSolid.test(next = check.method_10084()); ++i) {
            check = next;
        }
        return check;
    }

    @Nullable
    public static class_243 generateBestRandomPos(Supplier<class_2338> supplier, ToDoubleFunction<class_2338> scorer) {
        double bestScore = Double.NEGATIVE_INFINITY;
        class_2338 bestPos = null;
        for (int i = 0; i < 10; ++i) {
            class_2338 pos = supplier.get();
            if (pos == null) continue;
            double score = scorer.applyAsDouble(pos);
            if (!((score += (rng.nextDouble() - 0.5) * 0.01) > bestScore)) continue;
            bestScore = score;
            bestPos = pos;
        }
        return bestPos != null ? class_243.method_24955(bestPos) : null;
    }

    public static class_2338 generateRandomPosTowardDirection(class_1314 mob, int range, class_2338 offset) {
        int dx = offset.method_10263();
        int dz = offset.method_10260();
        if (mob.method_18410() && range > 1) {
            class_2338 center = mob.method_18412();
            dx += mob.method_23317() > (double)center.method_10263() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
            dz += mob.method_23321() > (double)center.method_10260() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
        }
        return class_2338.method_49637((double)(mob.method_23317() + (double)dx), (double)(mob.method_23318() + (double)offset.method_10264()), (double)(mob.method_23321() + (double)dz));
    }

    @Nullable
    public static class_243 findTargetPos(class_1314 mob, int xRange, int yRange, int yVariation) {
        class_2338 origin = mob.method_24515();
        return JSRandomPos.generateBestRandomPos(() -> {
            int dx = mob.method_6051().method_43048(xRange * 2 + 1) - xRange;
            int dy = mob.method_6051().method_43048(yRange * 2 + 1) - yRange;
            int dz = mob.method_6051().method_43048(xRange * 2 + 1) - xRange;
            class_2338 candidate = origin.method_10069(dx, dy, dz);
            if (mob.method_37908().method_8320(candidate).method_51367()) {
                candidate = candidate.method_10084();
            }
            if (mob.method_37908().method_8320(candidate).method_51367()) {
                return null;
            }
            return candidate;
        }, pos -> mob.method_6149(pos));
    }
}

