/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.entity.obj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.block.obj.entity.VehicleGate;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class VehicleGateBlockEntity
extends class_2586 {
    private int openTicks = 0;
    private int closeTicks = 16;
    private int checkCooldown = 0;
    private boolean openedByCar = false;
    public boolean isOpen = false;
    private boolean isActuallyOpen = false;
    private boolean isActuallyClosed = true;
    private static final HashMap<class_2338, class_2338> BLOCK_POS_BLOCK_ENTITY = new HashMap();
    private final class_2338 mainPos;

    public VehicleGateBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)JSBlockEntities.VEHICLE_GATE.get(), pos, state);
        this.mainPos = pos;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, VehicleGateBlockEntity be) {
        if (level.field_9236) {
            be.animate();
        } else {
            if (be.isOpen) {
                if (be.openTicks < 21) {
                    ++be.openTicks;
                }
                if (be.openTicks >= 20) {
                    be.isActuallyOpen = true;
                }
            } else {
                if (be.closeTicks < 21) {
                    ++be.closeTicks;
                }
                if (be.closeTicks >= 20) {
                    be.isActuallyClosed = true;
                }
            }
            if (be.checkCooldown-- <= 0) {
                JSVehicleEntity nearest = VehicleGateBlockEntity.findNearestVehicle(level, be.getMainPos(), 16.0);
                if (nearest != null) {
                    if (!be.isOpen) {
                        be.toggleOpen(null);
                        be.openedByCar = true;
                    }
                } else if (be.openedByCar && be.isOpen) {
                    be.toggleOpen(null);
                    be.openedByCar = false;
                }
                be.checkCooldown = 20;
            }
            be.method_5431();
            if (be.closeTicks < 20 || be.openTicks < 20) {
                level.method_8413(be.mainPos, be.method_11010(), be.method_11010(), 3);
            }
        }
    }

    @Nullable
    private static JSVehicleEntity findNearestVehicle(class_1937 level, class_2338 mainPos, double radius) {
        if (level.field_9236) {
            return null;
        }
        class_243 center = class_243.method_24953((class_2382)mainPos);
        class_238 box = new class_238(center, center).method_1014(radius);
        List list = level.method_8390(JSVehicleEntity.class, box, e -> e.canTriggerNearbyDoors());
        if (list.isEmpty()) {
            return null;
        }
        double radiusSq = radius * radius;
        double bestDistSq = Double.MAX_VALUE;
        JSVehicleEntity nearest = null;
        for (JSVehicleEntity e2 : list) {
            double dSq = e2.method_5649(center.field_1352, center.field_1351, center.field_1350);
            if (!(dSq <= radiusSq) || !(dSq < bestDistSq)) continue;
            bestDistSq = dSq;
            nearest = e2;
        }
        return nearest;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("openTicks", this.openTicks);
        tag.method_10569("closeTicks", this.closeTicks);
        tag.method_10556("isOpen", this.isOpen);
        tag.method_10556("isActuallyOpen", this.isActuallyOpen);
        tag.method_10556("isActuallyClosed", this.isActuallyClosed);
        tag.method_10556("openedByCar", this.openedByCar);
        List<class_2338> children = BLOCK_POS_BLOCK_ENTITY.entrySet().stream().filter(e -> ((class_2338)e.getValue()).equals((Object)this.mainPos)).map(Map.Entry::getKey).toList();
        tag.method_10569("childCount", children.size());
        for (int i = 0; i < children.size(); ++i) {
            class_2338 c = children.get(i);
            tag.method_10569("cX" + i, c.method_10263());
            tag.method_10569("cY" + i, c.method_10264());
            tag.method_10569("cZ" + i, c.method_10260());
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.openTicks = tag.method_10550("openTicks");
        this.closeTicks = tag.method_10545("closeTicks") ? tag.method_10550("closeTicks") : 16;
        this.isOpen = tag.method_10577("isOpen");
        this.isActuallyOpen = tag.method_10577("isActuallyOpen");
        this.isActuallyClosed = tag.method_10577("isActuallyClosed");
        this.openedByCar = tag.method_10577("openedByCar");
        int count = tag.method_10550("childCount");
        for (int i = 0; i < count; ++i) {
            class_2338 child = new class_2338(tag.method_10550("cX" + i), tag.method_10550("cY" + i), tag.method_10550("cZ" + i));
            BLOCK_POS_BLOCK_ENTITY.put(child, this.mainPos);
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10556("isOpen", this.isOpen);
        tag.method_10569("closeTicks", this.closeTicks);
        tag.method_10569("openTicks", this.openTicks);
        tag.method_10556("isActuallyOpen", this.isActuallyOpen);
        tag.method_10556("isActuallyClosed", this.isActuallyClosed);
        return tag;
    }

    public void toggleOpen(class_1657 player) {
        class_1937 level = this.method_10997();
        if (level == null) {
            return;
        }
        if (this.isActuallyClosed) {
            this.isOpen = true;
            this.isActuallyClosed = false;
            this.isActuallyOpen = false;
            this.openTicks = 0;
            this.method_5431();
            level.method_8413(this.mainPos, this.method_11010(), this.method_11010(), 3);
            VehicleGate.checkForDoorUpdate(this, this.method_11010(), level, this.mainPos);
        } else if (this.isActuallyOpen) {
            this.isOpen = false;
            this.isActuallyOpen = false;
            this.isActuallyClosed = false;
            this.closeTicks = 0;
            this.method_5431();
            level.method_8413(this.mainPos, this.method_11010(), this.method_11010(), 3);
            VehicleGate.checkForDoorUpdate(this, this.method_11010(), level, this.mainPos);
        } else if (player != null) {
            player.method_5783(class_3417.field_14731, 1.0f, 1.0f);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private void animate() {
        if (this.isOpen) {
            if (this.openTicks >= 15) {
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)this);
            } else {
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)this);
            }
        } else if (this.closeTicks >= 15) {
            JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)this);
        } else {
            JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)this);
        }
    }

    public void addOffsetBlockPos(class_2338 childPos) {
        BLOCK_POS_BLOCK_ENTITY.put(childPos, this.mainPos);
    }

    public void clear() {
        BLOCK_POS_BLOCK_ENTITY.entrySet().removeIf(e -> ((class_2338)e.getValue()).equals((Object)this.mainPos));
    }

    public static HashMap<class_2338, class_2338> getBLOCK_POS_BLOCK_ENTITY() {
        return BLOCK_POS_BLOCK_ENTITY;
    }

    public class_2338 getMainPos() {
        return this.mainPos;
    }
}

