/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.stream.Stream;
import jp.jurassicsaga.JSCommon;
import net.minecraft.class_1937;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class JSPlantBlock
extends class_2261
implements class_2256 {
    protected final int spreadRadius = 5;
    protected final int spreadHeight = 2;
    protected final int maxSamePlant = 3;
    protected final boolean requiresLight;
    protected final boolean spreadsAtDay;
    protected final int spreadChance = 50;

    public JSPlantBlock(class_4970.class_2251 props, boolean requiresLight, boolean spreadsAtDay) {
        super(props.method_9640());
        this.requiresLight = requiresLight;
        this.spreadsAtDay = spreadsAtDay;
    }

    public JSPlantBlock(class_4970.class_2251 props, boolean requiresLight) {
        this(props.method_9640(), requiresLight, true);
    }

    public JSPlantBlock(class_4970.class_2251 props) {
        this(props.method_9640(), true, true);
    }

    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state, boolean isClient) {
        return true;
    }

    public boolean method_9650(@NotNull class_1937 level, class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return random.method_43048(7) == 0;
    }

    public void method_9652(@NotNull class_3218 level, class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        for (int i = 0; i < random.method_43051(1, 4); ++i) {
            if (!level.method_8477(pos)) {
                return;
            }
            if (!this.isSpreadSuccess((class_1937)level, random, pos, state)) continue;
            this.performSpread((class_1937)level, random, pos, state);
        }
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        super.method_9514(state, level, pos, random);
        if (!level.method_8477(pos)) {
            return;
        }
        if (!level.method_8450().method_8355(JSCommon.PLANT_SPREADING)) {
            return;
        }
        if ((float)random.method_43048(100) > 75.0f) {
            return;
        }
        if (this.isSpreadSuccess((class_1937)level, random, pos, state)) {
            this.performSpread((class_1937)level, random, pos, state);
        }
    }

    public boolean isSpreadSuccess(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        if (this.requiresLight ? !this.spreadsAtDay || level.method_8530() && level.method_22339(pos.method_10084()) >= 9 : !this.spreadsAtDay || level.method_8530() && level.method_22339(pos.method_10084()) <= 8) {
            return this.getNumberOfNeibours(level, pos) < 6 && this.isWaterInRange(level, pos);
        }
        return false;
    }

    public void performSpread(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        class_2338 spreadTo = this.getSpreadPosition(level, random, pos, state, 5, 2);
        class_2680 spr = level.method_8320(spreadTo);
        if (spr.method_26204() != this && spr.method_26215() && level.method_8320(spreadTo.method_10074()).method_26164(class_3481.field_29822)) {
            level.method_8501(spreadTo, this.method_9564());
        }
    }

    public class_2338 getSpreadPosition(class_1937 level, class_5819 random, class_2338 pos, class_2680 state, int radius, int verticalDistance) {
        return pos.method_10069(random.method_43048(radius * 2) - radius, random.method_43048(verticalDistance * 2) - verticalDistance, random.method_43048(radius * 2) - radius);
    }

    public int getNumberOfNeibours(class_1937 worldIn, class_2338 originalPos) {
        int spreadxz = 2;
        int y = 1;
        Stream e = class_2338.class_2339.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).method_996(originalPos));
        Stream<class_2338> filtered = e.filter(blockPos -> worldIn.method_8320(blockPos).method_26204() == this);
        return (int)filtered.count() - 1;
    }

    public boolean isWaterInRange(class_1937 worldIn, class_2338 pos) {
        int spreadxz = 5;
        int y = 1;
        Stream e = class_2338.class_2339.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).method_996(pos));
        return e.anyMatch(blockPos -> worldIn.method_8320(blockPos).method_26227().method_15767(class_3486.field_15517));
    }
}

