/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.stream.Stream;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTallPlantBlock
extends JSPlantBlock {
    public static final class_2754<SegmentPart> SEGMENT = JSBlockStateProperties.SEGMENTED;
    protected static final class_265 SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected final int wantedSegmentCount;

    public JSTallPlantBlock(int wantedSegmentCount, class_4970.class_2251 properties) {
        super(properties.method_9640());
        this.wantedSegmentCount = wantedSegmentCount > 9 ? 8 : wantedSegmentCount;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(SEGMENT, (Comparable)((Object)SegmentPart.SEGMENT_1)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SEGMENT});
    }

    public void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);
        if (level instanceof class_3218 && state.method_26204() == this && state.method_28498(JSBlockStateProperties.SEGMENTED) && state.method_11654(JSBlockStateProperties.SEGMENTED) == SegmentPart.SEGMENT_1) {
            this.updateSegments(level, pos);
        }
    }

    @Override
    public void method_9514(@NotNull class_2680 state, class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!level.method_8477(pos)) {
            return;
        }
        if (state.method_11654(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1)) {
            super.method_9514(state, level, pos, random);
        }
        if (level.method_22339(pos.method_10084()) >= 9 && random.method_43048(4) == 0 && level.method_8320(pos.method_10084()).method_26215() && this.countSegments((class_1922)level, pos) < this.wantedSegmentCount) {
            level.method_8652(pos.method_10084(), this.method_9564(), 2);
        }
    }

    public void method_9585(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        super.method_9585(level, pos, state);
        if (level instanceof class_1937) {
            class_1937 actualLevel = (class_1937)level;
            this.updateSegments(actualLevel, pos.method_10074());
        }
    }

    public void method_9556(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @NotNull class_1799 tool) {
        super.method_9556(level, player, pos, state, blockEntity, tool);
        this.updateSegments(level, pos.method_10074());
    }

    public int countSegments(class_1922 worldIn, class_2338 pos) {
        for (int i = 0; i < this.wantedSegmentCount + 1; ++i) {
            class_2680 state = worldIn.method_8320(pos.method_10087(i));
            if (state.method_26204() == this) {
                continue;
            }
            return i;
        }
        return -1;
    }

    public boolean method_22358(class_2680 state, @NotNull class_3611 fluid) {
        return state.method_11654(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1);
    }

    public void updateSegments(class_1937 world, class_2338 pos) {
        class_2338 top = pos;
        while (world.method_8320(top.method_10084()).method_26204() == this) {
            top = top.method_10084();
        }
        class_2338 current = top;
        for (int segmentIndex = 0; world.method_8320(current).method_26204() == this && segmentIndex <= this.wantedSegmentCount; ++segmentIndex) {
            SegmentPart part = SegmentPart.getSegment(segmentIndex);
            class_2680 state = world.method_8320(current);
            class_2680 newState = (class_2680)this.method_9564().method_11657(SEGMENT, (Comparable)((Object)part));
            if (state.method_26204() == this && state.method_28498(SEGMENT) && state.method_11654(SEGMENT) != part) {
                world.method_8652(current, newState, 2);
            }
            current = current.method_10074();
        }
    }

    protected boolean method_9695(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return super.method_9695(state, level, pos) || level.method_8320(pos).method_26204() == this && this.countSegments(level, pos) < this.wantedSegmentCount;
    }

    @Override
    public void method_9652(@NotNull class_3218 level, class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        super.method_9652(level, random, pos, state);
        if (level.method_8320(pos.method_10084()).method_26204() == class_2246.field_10124 && this.method_9695(level.method_8320(pos), (class_1922)level, pos)) {
            level.method_8501(pos.method_10093(class_2350.field_11036), this.method_9564());
            this.updateSegments((class_1937)level, pos.method_10084());
        } else {
            class_2248 class_22482 = level.method_8320(pos.method_10084()).method_26204();
            if (class_22482 instanceof JSTallPlantBlock) {
                JSTallPlantBlock block = (JSTallPlantBlock)class_22482;
                block.method_9652(level, random, pos.method_10084(), state);
            }
        }
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_243 vec3d = state.method_26226(level, pos);
        return SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public void method_9612(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2248 neighborBlock, @NotNull class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (neighborPos.equals((Object)pos.method_10074())) {
            this.updateSegments(level, pos);
        }
    }

    @Override
    public boolean isSpreadSuccess(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return state.method_11654(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1) && super.isSpreadSuccess(level, random, pos, state);
    }

    @Override
    public int getNumberOfNeibours(class_1937 worldIn, class_2338 originalPos) {
        int spreadXz = 5;
        int y = 2;
        Stream e = class_2338.class_2339.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(-spreadXz, -y, -spreadXz, spreadXz, y, spreadXz)).method_996(originalPos));
        Stream<class_2338> filtered = e.filter(blockPos -> worldIn.method_8320(blockPos).method_26204() == this && worldIn.method_8320(blockPos).method_11654(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1));
        return (int)filtered.count() - 1;
    }

    public int getWantedSegmentCount() {
        return this.wantedSegmentCount;
    }
}

