/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.client.base.sound.SoundRelayer;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.entity.obj.other.LerpRotHolder;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.VehicleAnimations;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import jp.jurassicsaga.server.v2.item.obj.WrenchItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public abstract class JSVehicleEntity
extends class_1297
implements LerpRotHolder {
    protected static final class_2940<Float> CURRENT_SPEED = class_2945.method_12791(JSVehicleEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> HEALTH = class_2945.method_12791(JSVehicleEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> HAS_DRIVER = class_2945.method_12791(JSVehicleEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CAN_BE_DRIVEN = class_2945.method_12791(JSVehicleEntity.class, (class_2941)class_2943.field_13323);
    protected final VehicleAnimations module;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    public float yHeadRot;
    public float yHeadRotO;
    public float rearWheelRot = 0.0f;
    public float frontLeftWheelRot = 0.0f;
    public float frontRightWheelRot = 0.0f;
    protected final List<SeatEntity> seats = new LinkedList<SeatEntity>();
    protected float maxSpeed = 2.0f;
    protected float maxSpeedBackwards = 0.5f;
    protected float acceleration = 0.1f;
    protected float turnSpeed = 0.1f;
    protected float maxTurnSpeed = 5.0f;
    protected float currentTurn = 0.0f;
    protected final SeatEntity driverSeat;
    protected boolean hasDriver = true;

    public JSVehicleEntity(class_1299<? extends JSVehicleEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.initializeSeats();
        this.driverSeat = this.seats.get(0);
        for (SeatEntity seat : this.seats) {
            level.method_8649((class_1297)seat);
            class_243 relative = seat.getRelativePos();
            seat.method_5859(relative.field_1352, relative.field_1351, relative.field_1350);
        }
        this.module = new VehicleAnimations(this);
        if (!level.field_9236) {
            this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(100.0f));
        }
    }

    public boolean method_5863() {
        return true;
    }

    protected abstract void initializeSeats();

    protected void addSeat(double x, double y, double z) {
        this.seats.add(new SeatEntity(this.method_37908(), new class_243(x, y, z), true, this));
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5765()) {
            if (this.driverSeat.method_31483() != null && this.driverSeat.method_31483() == player) {
                if (!this.method_37908().field_9236) {
                    this.honk();
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (!this.hasRiders()) {
            if (player.method_5715() && !this.method_37908().field_9236 && this.shiftInteraction(player, hand)) {
                return class_1269.field_5812;
            }
            if (player.method_5998(hand).method_31574((class_1792)JSV2Items.WRENCH.get())) {
                if (!this.method_37908().field_9236) {
                    return this.wrenchInteract(hand, WrenchItem.WrenchMode.fromStack(player.method_5998(hand)), player);
                }
                return class_1269.field_5812;
            }
            SeatEntity closestSeat = null;
            double closestDistance = Double.MAX_VALUE;
            for (SeatEntity seat : this.seats) {
                double distance = player.method_19538().method_1022(seat.method_19538());
                if (!(distance < closestDistance)) continue;
                closestSeat = seat;
                closestDistance = distance;
            }
            if (closestSeat != null && closestSeat.hasNoPassenger()) {
                player.method_5804((class_1297)closestSeat);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    protected boolean hasRiders() {
        for (SeatEntity seat : this.seats) {
            if (seat.hasNoPassenger()) continue;
            return true;
        }
        return false;
    }

    void honk() {
        class_1297 passenger;
        this.method_37908().method_8396(null, this.method_23312(), (class_3414)JSSounds.CAR_HONK.get(), class_3419.field_15245, 1.5f, 1.0f);
        Optional<SeatEntity> optionalSeatEntity = this.seats.stream().filter(seatEntity -> seatEntity.method_31483() != null).findFirst();
        if (optionalSeatEntity.isPresent() && (passenger = optionalSeatEntity.get().method_31483()) instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            List animals = this.method_37908().method_8390(JSAnimalBase.class, this.method_5829().method_1014(10.0), a -> true);
            for (JSAnimalBase animal : animals) {
                if (animal.getModules().getMetabolismModule().canTarget(true, true, this)) {
                    animal.method_5980((class_1309)player);
                    JSAnimalBase trueLeader = animal.getModules().getHerdModule().getTrueLeader();
                    if (trueLeader != null) {
                        for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                            if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                                follower.method_5980((class_1309)player);
                                continue;
                            }
                            follower.setFleeTarget((class_1297)player);
                        }
                        trueLeader.method_5980((class_1309)player);
                    }
                    animal.setFleeTarget(null);
                    continue;
                }
                animal.setFleeTarget((class_1297)player);
                animal.method_5980(null);
            }
        }
    }

    protected class_1269 wrenchInteract(class_1268 hand, WrenchItem.WrenchMode wrenchMode, class_1657 player) {
        return class_1269.field_5812;
    }

    protected boolean shiftInteraction(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand != null) {
            if (!itemInHand.method_7960()) {
                if (((Float)this.field_6011.method_12789(HEALTH)).floatValue() < 100.0f) {
                    boolean takeOne = false;
                    if (itemInHand.method_31574(class_1802.field_8620)) {
                        takeOne = true;
                        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(Math.min(100.0f, ((Float)this.field_6011.method_12789(HEALTH)).floatValue() + 25.0f)));
                    } else if (itemInHand.method_31574(class_1802.field_8773)) {
                        takeOne = true;
                        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(100.0f));
                    } else if (itemInHand.method_31574(class_1802.field_8675)) {
                        takeOne = true;
                        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(Math.min(100.0f, ((Float)this.field_6011.method_12789(HEALTH)).floatValue() + 2.0f)));
                    }
                    if (takeOne) {
                        if (itemInHand.method_7947() > 1) {
                            itemInHand.method_7934(1);
                        } else {
                            itemInHand = class_1799.field_8037;
                        }
                        player.method_6122(hand, itemInHand);
                        player.method_5783(class_3417.field_21077, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (this.vehicleItem() != null) {
                class_1799 vehicleItem = this.vehicleItem().method_7854();
                Float health = (Float)this.field_6011.method_12789(HEALTH);
                class_2487 tag = vehicleItem.method_7948();
                tag.method_10548("health", health.floatValue());
                vehicleItem.method_7980(tag);
                if (player.method_31548().method_7394(vehicleItem)) {
                    this.method_5650(class_1297.class_5529.field_26999);
                    this.onRemove();
                    return true;
                }
            }
        }
        return false;
    }

    protected void onRemove() {
    }

    protected abstract class_1792 vehicleItem();

    public boolean method_36971(class_1937 level, class_2338 pos) {
        return true;
    }

    public boolean method_5698(class_1297 entity) {
        return false;
    }

    public void disableDriver() {
        this.hasDriver = false;
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        return super.method_5664(player, vec, hand);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_30949(class_1297 entity) {
        return class_1690.method_30959((class_1297)this, (class_1297)entity);
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_5749(class_2487 compoundTag) {
        if (compoundTag.method_10545("health")) {
            this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(compoundTag.method_10583("health")));
        }
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10548("health", ((Float)this.field_6011.method_12789(HEALTH)).floatValue());
    }

    public boolean method_49108() {
        return true;
    }

    public boolean method_48155() {
        return false;
    }

    protected void method_5693() {
        this.field_6011.method_12784(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(HEALTH, (Object)Float.valueOf(100.0f));
        this.field_6011.method_12784(HAS_DRIVER, (Object)false);
        this.field_6011.method_12784(CAN_BE_DRIVEN, (Object)false);
    }

    public boolean method_31747() {
        return true;
    }

    public void method_5773() {
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.yHeadRotO = this.yHeadRot;
        this.yHeadRot = this.method_36454();
        super.method_5773();
        this.tickLerp();
        if (!this.method_37908().field_9236) {
            this.animateServer();
            if (this.hasDriver && this.driverSeat != null && !this.method_5799()) {
                class_1657 driver = (class_1657)this.driverSeat.method_31483();
                if (driver == null) {
                    this.field_6011.method_12778(HAS_DRIVER, (Object)false);
                }
                this.updateDriver(driver);
            } else {
                this.updateNoDriver();
            }
            this.handleCollision();
            this.checkForClimbingBlocks();
            this.updateSeats(this.method_36454());
        } else {
            float health = ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
            if (health < 80.0f) {
                int amount = class_3532.method_15340((int)((int)((80.0f - health) / 60.0f) + 1), (int)1, (int)2);
                float forwardOffset = 2.0f;
                float yawRad = this.method_36454() * ((float)Math.PI / 180);
                double fx = Math.sin(-yawRad) * (double)forwardOffset;
                double fz = Math.cos(-yawRad) * (double)forwardOffset;
                for (int i = 0; i < amount; ++i) {
                    double px = this.field_6014 + fx + (this.field_5974.method_43058() - 0.5) * 1.0;
                    double py = this.field_6036 + 1.5 + this.field_5974.method_43058() * 0.1;
                    double pz = this.field_5969 + fz + (this.field_5974.method_43058() - 0.5) * 1.0;
                    double vy = 0.05 + this.field_5974.method_43058() * 0.2;
                    class_2400 smokeType = health < 60.0f ? class_2398.field_11237 : class_2398.field_11251;
                    this.method_37908().method_8406((class_2394)smokeType, px, py, pz, 0.0, vy, 0.0);
                    if (!(health < 10.0f) || !(this.field_5974.method_43057() < 0.3f)) continue;
                    this.method_37908().method_8406((class_2394)class_2398.field_11239, px, py, pz, 0.0, 0.1, 0.0);
                }
            }
        }
        if (this.method_37908().field_9236) {
            if (((Boolean)this.field_6011.method_12789(HAS_DRIVER)).booleanValue()) {
                SoundRelayer.playCarLoop(this);
            } else if ((double)((Float)this.field_6011.method_12789(CURRENT_SPEED)).floatValue() == 0.0) {
                SoundRelayer.stopCarLoop(this);
            }
        }
    }

    protected void updateNoDriver() {
        if (((Boolean)this.field_6011.method_12789(HAS_DRIVER)).booleanValue()) {
            this.field_6011.method_12778(HAS_DRIVER, (Object)false);
        }
        float currentSpeed = this.getCurrentSpeed();
        if (Math.abs(currentSpeed *= 0.9f) < 1.0E-4f) {
            currentSpeed = 0.0f;
        }
        this.currentTurn *= 0.85f;
        if (Math.abs(this.currentTurn) < 1.0E-4f) {
            this.currentTurn = 0.0f;
        }
        this.method_36456(this.method_36454() + this.currentTurn);
        double dx = -Math.sin(Math.toRadians(this.method_36454())) * (double)currentSpeed;
        double dz = Math.cos(Math.toRadians(this.method_36454())) * (double)currentSpeed;
        class_243 movementVec = this.applyGravityToVec(dx, dz);
        this.method_5784(class_1313.field_6308, movementVec);
        this.setCurrentSpeed(currentSpeed);
    }

    protected void updateDriver(class_1657 driver) {
        float currentSpeed = this.getCurrentSpeed();
        this.field_6011.method_12778(HAS_DRIVER, (Object)(driver != null ? 1 : 0));
        if (driver instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)driver;
            if ((double)serverPlayer.field_6250 > 0.0) {
                currentSpeed = Math.min(currentSpeed + this.acceleration, this.maxSpeed);
            } else if ((double)serverPlayer.field_6250 < 0.0) {
                currentSpeed = Math.max(currentSpeed - this.acceleration, -this.maxSpeedBackwards);
            } else if (Math.abs(currentSpeed *= 0.7f) < 1.0E-4f) {
                currentSpeed = 0.0f;
            }
            this.currentTurn = (double)serverPlayer.field_6212 < 0.0 ? this.maxTurnSpeed : ((double)serverPlayer.field_6212 > 0.0 ? -this.maxTurnSpeed : 0.0f);
        } else {
            if (Math.abs(currentSpeed *= 0.7f) < 1.0E-4f) {
                currentSpeed = 0.0f;
            }
            this.currentTurn = 0.0f;
        }
        this.method_36456(this.method_36454() + this.currentTurn);
        double dx = -Math.sin(Math.toRadians(this.method_36454())) * (double)currentSpeed;
        double dz = Math.cos(Math.toRadians(this.method_36454())) * (double)currentSpeed;
        class_243 movementVec = this.applyGravityToVec(dx, dz);
        this.method_5784(class_1313.field_6308, movementVec);
        this.setCurrentSpeed(currentSpeed);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        Float health = (Float)this.field_6011.method_12789(HEALTH);
        if ((health = Float.valueOf(health.floatValue() - amount)).floatValue() <= 0.0f) {
            if (this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 2.0f, class_1937.class_7867.field_40889);
            }
            for (SeatEntity seat : this.seats) {
                seat.method_5650(class_1297.class_5529.field_26998);
            }
            this.method_5650(class_1297.class_5529.field_26998);
        }
        this.field_6011.method_12778(HEALTH, (Object)health);
        return true;
    }

    public boolean method_5732() {
        return true;
    }

    protected void animateServer() {
        boolean isMoving = (double)this.getCurrentSpeed() != 0.0 && !this.method_5799();
        boolean left = this.hasPlayerOnSide(false);
        boolean right = this.hasPlayerOnSide(true);
        this.module.playTransition(left && !isMoving, JSAnimations.VEHICLE_OPEN_DOOR_LEFT.wrap(10), JSAnimations.VEHICLE_OPENED_DOOR_LEFT.wrap(), JSAnimations.VEHICLE_CLOSE_DOOR_LEFT.wrap(10));
        this.module.playTransition(right && !isMoving, JSAnimations.VEHICLE_OPEN_DOOR_RIGHT.wrap(10), JSAnimations.VEHICLE_OPENED_DOOR_RIGHT.wrap(), JSAnimations.VEHICLE_CLOSE_DOOR_RIGHT.wrap(10));
    }

    public boolean method_5799() {
        return !this.method_37908().method_8316(class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, 1.5, 0.0))).method_15769();
    }

    private boolean hasPlayerOnSide(boolean right) {
        double range = 3.0;
        List players = this.method_37908().method_8390(class_1657.class, this.method_5829().method_1014(range), p -> !p.method_7325() && p.method_5805() && !p.method_5765());
        if (players.isEmpty()) {
            return false;
        }
        float bodyRot = this.method_36454();
        class_243 forward = class_243.method_1030((float)0.0f, (float)bodyRot);
        class_243 rightVec = new class_243(forward.field_1350, 0.0, -forward.field_1352);
        for (class_1657 p2 : players) {
            class_243 rel = p2.method_19538().method_1020(this.method_19538());
            double side = rel.method_1026(rightVec);
            if (!right && side > 0.0) {
                return true;
            }
            if (!right || !(side < 0.0)) continue;
            return true;
        }
        return false;
    }

    class_243 applyGravityToVec(double dx, double dz) {
        return new class_243(dx, -1.0, dz);
    }

    protected void checkForClimbingBlocks() {
        class_243[] dirs;
        double checkDist = (double)this.method_17681() + 0.1;
        double push = 0.55;
        double yaw = Math.toRadians(this.method_36454());
        double sin = Math.sin(yaw);
        double cos = Math.cos(yaw);
        class_243 forward = new class_243(-sin, 0.0, cos);
        for (class_243 d : dirs = new class_243[]{forward, new class_243(-sin + cos * 0.7, 0.0, cos + sin * 0.7), new class_243(-sin - cos * 0.7, 0.0, cos - sin * 0.7)}) {
            boolean entitySpaceClear;
            class_243 nd = d.method_1029();
            double checkX = this.method_23317() + nd.field_1352 * checkDist;
            double checkZ = this.method_23321() + nd.field_1350 * checkDist;
            class_2338 pos = new class_2338(class_3532.method_15357((double)checkX), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)checkZ));
            if (!this.method_37908().method_8320(pos).method_51367()) continue;
            class_2680 base = this.method_37908().method_8320(pos);
            class_2680 step = this.method_37908().method_8320(pos.method_10084());
            class_2680 step2 = this.method_37908().method_8320(pos.method_10086(2));
            boolean isStep = base.method_51367() && step.method_26220((class_1922)this.method_37908(), pos.method_10084()).method_1110() && step2.method_26220((class_1922)this.method_37908(), pos.method_10086(2)).method_1110();
            class_2338 entUp = this.method_24515().method_10086((int)this.method_17682());
            class_2338 entUp2 = entUp.method_10084();
            boolean bl = entitySpaceClear = this.method_37908().method_8320(entUp).method_26220((class_1922)this.method_37908(), entUp).method_1110() && this.method_37908().method_8320(entUp2).method_26220((class_1922)this.method_37908(), entUp2).method_1110();
            if (isStep) {
                if (entitySpaceClear) {
                    class_243 p = this.method_19538();
                    class_243 newPos = new class_243(p.field_1352 + nd.field_1352 * 0.55, p.field_1351 + 1.0, p.field_1350 + nd.field_1350 * 0.55);
                    if (!this.canMoveTo(newPos)) break;
                    this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
                    break;
                }
            } else if (d == forward) {
                this.setCurrentSpeed(0.0f);
            }
            return;
        }
    }

    private boolean canMoveTo(class_243 newPos) {
        class_238 movedBox = this.method_5829().method_997(newPos).method_1014(0.1);
        return this.method_37908().method_8587((class_1297)this, movedBox);
    }

    void handleCollision() {
        if ((double)Math.abs(this.getCurrentSpeed()) < 0.1) {
            return;
        }
        class_238 boundingBox = this.method_5829();
        class_243 movementDirection = new class_243(-Math.sin(Math.toRadians(this.method_36454())), 0.0, Math.cos(Math.toRadians(this.method_36454()))).method_1029();
        List collidedEntities = this.method_37908().method_8333((class_1297)this, boundingBox.method_1014((double)0.1f).method_997(movementDirection.method_18805(0.1, 1.0, 0.1)), entity -> {
            ArrayList<class_1297> entities = new ArrayList<class_1297>();
            for (SeatEntity seat : this.seats) {
                if (seat.method_31483() == null) continue;
                entities.add(seat.method_31483());
            }
            return !entities.contains(entity) && this.method_30949((class_1297)entity);
        });
        for (class_1297 entity2 : collidedEntities) {
            class_243 entityDirection;
            double dotProduct;
            if (!(entity2 instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity2;
            if (entity2 == this.method_31483() || !((dotProduct = movementDirection.method_1026(entityDirection = entity2.method_19538().method_1020(this.method_19538()).method_1029())) > 0.5)) continue;
            this.setCurrentSpeed(this.getCurrentSpeed() - 1.0f);
            this.method_37908().method_8396(null, this.method_23312(), (class_3414)JSSounds.CAR_BONK.get(), class_3419.field_15245, 1.5f, 1.0f);
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && this.method_37908().field_9236) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    protected void lerpPositionAndRotationStep(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d0 = 1.0 / (double)steps;
        double d1 = class_3532.method_16436((double)d0, (double)this.method_23317(), (double)targetX);
        double d2 = class_3532.method_16436((double)d0, (double)this.method_23318(), (double)targetY);
        double d3 = class_3532.method_16436((double)d0, (double)this.method_23321(), (double)targetZ);
        float f = class_3532.method_17821((float)((float)d0), (float)this.method_36454(), (float)((float)targetYRot));
        float f1 = (float)class_3532.method_16436((double)d0, (double)this.method_36455(), (double)targetXRot);
        this.method_5814(d1, d2, d3);
        this.method_5710(f, f1);
    }

    public float getCurrentSpeed() {
        return ((Float)this.method_5841().method_12789(CURRENT_SPEED)).floatValue();
    }

    public void setCurrentSpeed(float speed) {
        this.method_5841().method_12778(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.method_23317();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.method_23318();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.method_23321();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.method_36455();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.method_36454();
    }

    private float approachZero(float value, float step) {
        if (value > 0.0f) {
            return Math.max(value - step, 0.0f);
        }
        if (value < 0.0f) {
            return Math.min(value + step, 0.0f);
        }
        return 0.0f;
    }

    void updateSeats(float yRot) {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        double cosRot = Math.cos(Math.toRadians(yRot));
        double sinRot = Math.sin(Math.toRadians(yRot));
        for (SeatEntity seat : this.seats) {
            if (seat.getRelativePos() == null) continue;
            double relativeX = seat.getRelativePos().field_1352;
            double relativeZ = seat.getRelativePos().field_1350;
            double rotatedX = relativeX * cosRot - relativeZ * sinRot;
            double rotatedZ = relativeX * sinRot + relativeZ * cosRot;
            seat.method_36456(yRot);
            seat.method_33574(new class_243(x + rotatedX, y + seat.getRelativePos().field_1351, z + rotatedZ));
        }
    }

    public void initItem(class_1799 itemInHand, class_1838 context) {
    }

    public void setHealth(float health) {
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(health));
    }

    public boolean canTriggerNearbyDoors() {
        return false;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public float getMaxSpeedBackwards() {
        return this.maxSpeedBackwards;
    }

    public void setMaxSpeedBackwards(float maxSpeedBackwards) {
        this.maxSpeedBackwards = maxSpeedBackwards;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float acceleration) {
        this.acceleration = acceleration;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float turnSpeed) {
        this.turnSpeed = turnSpeed;
    }

    public float getMaxTurnSpeed() {
        return this.maxTurnSpeed;
    }

    public void setMaxTurnSpeed(float maxTurnSpeed) {
        this.maxTurnSpeed = maxTurnSpeed;
    }

    public float getCurrentTurn() {
        return this.currentTurn;
    }
}

