/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.physics;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public abstract class PhysicsEntity
extends class_1297 {
    private class_243 angularVelocity = class_243.field_1353;
    private float zRot = 0.0f;
    private float zRotOld = 0.0f;
    public final float[] rawXRotHistory = new float[3];
    public final float[] rawYRotHistory = new float[3];
    public final float[] rawZRotHistory = new float[3];
    private float lastXRot;
    private float lastYRot;
    private float lastZRot;
    private float xAccum;
    private float yAccum;
    private float zAccum;

    public PhysicsEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        class_243 horiz;
        super.method_5773();
        double gravity = this.getPhysicsGravity();
        double bounciness = this.getBounciness();
        double friction = this.getFriction();
        double angularDrag = this.getAngularDrag();
        double smoothFactor = this.getPhysicsSmoothing();
        class_243 velocity = this.method_18798();
        class_243 pushForce = class_243.field_1353;
        double pushStrength = 0.05;
        List nearby = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(3.0), e -> e != this);
        for (class_1297 other : nearby) {
            class_243 diff = this.method_19538().method_1020(other.method_19538());
            double dist = diff.method_1027() * 2.0;
            if (!(dist > 0.0) || !(dist < 1.0)) continue;
            class_243 dir = diff.method_1029();
            double factor = 1.0 - dist;
            class_243 relVel = this.method_18798().method_1020(other.method_18798());
            double relSpeed = relVel.method_1026(dir);
            double momentum = class_3532.method_15350((double)relSpeed, (double)-1.0, (double)1.0);
            pushForce = pushForce.method_1019(dir.method_1021(pushStrength * factor * (1.0 + momentum)));
        }
        velocity = velocity.method_1019(pushForce);
        velocity = !this.method_37908().method_8316(this.method_24515()).method_15769() ? velocity.method_1031(0.0, 0.01, 0.0) : velocity.method_1031(0.0, -gravity, 0.0);
        this.method_5784(class_1313.field_6308, velocity);
        if (this.field_5976 && (horiz = new class_243(velocity.field_1352, 0.0, velocity.field_1350)).method_1027() > 1.0E-4) {
            class_243 normal = horiz.method_1029();
            double impact = class_3532.method_15350((double)(Math.abs(velocity.method_1026(normal)) * 2.0), (double)1.0, (double)10.0);
            double bounce = bounciness * impact;
            velocity = velocity.method_1020(normal.method_1021(2.0 * velocity.method_1026(normal))).method_1021(bounce);
        }
        if (this.field_5992 && velocity.field_1351 < 0.0) {
            double impactFactor = class_3532.method_15350((double)Math.abs(velocity.field_1351), (double)0.5, (double)2.0);
            double bounce = bounciness * impactFactor;
            velocity = new class_243(velocity.field_1352, -velocity.field_1351 * bounce, velocity.field_1350);
            this.angularVelocity = this.angularVelocity.method_1031((velocity.field_1350 - velocity.field_1352) * 10.0, this.field_5974.method_43058() * 15.0 - 7.5, (velocity.field_1352 + velocity.field_1350) * 10.0);
        }
        double angularSpeed = this.angularVelocity.method_1033();
        double angularFriction = 1.0 - class_3532.method_15350((double)Math.pow(angularSpeed * 4.0, 2.0), (double)0.0, (double)1.0);
        angularFriction = class_3532.method_15350((double)angularFriction, (double)angularDrag, (double)0.98);
        this.angularVelocity = this.angularVelocity.method_1031(velocity.field_1350 * 5.0, 0.0, -velocity.field_1352 * 5.0);
        this.angularVelocity = new class_243(this.lerp(this.angularVelocity.field_1352, this.angularVelocity.field_1352, smoothFactor), this.lerp(this.angularVelocity.field_1351, this.angularVelocity.field_1351, smoothFactor), this.lerp(this.angularVelocity.field_1350, this.angularVelocity.field_1350, smoothFactor));
        boolean setYRot = true;
        if (this.field_5992 && velocity.method_1027() < 0.01) {
            this.angularVelocity = new class_243(class_3532.method_16436((double)0.1f, (double)this.angularVelocity.field_1352, (double)0.0), this.angularVelocity.field_1351 * angularDrag, class_3532.method_16436((double)0.1f, (double)this.angularVelocity.field_1350, (double)0.0));
            this.method_36457(class_3532.method_16439((float)0.1f, (float)this.method_36455(), (float)0.0f));
            this.setZRot(class_3532.method_16439((float)0.1f, (float)this.getZRot(), (float)0.0f));
            setYRot = false;
        } else {
            this.angularVelocity = this.angularVelocity.method_18805(angularDrag, angularDrag, angularDrag);
        }
        this.angularVelocity = this.angularVelocity.method_18805(angularFriction, angularFriction, angularFriction);
        velocity = velocity.method_18805(friction, friction, friction);
        this.method_18799(velocity);
        this.zRotOld = this.zRot;
        if (setYRot) {
            this.method_36457(this.method_36455() + (float)this.angularVelocity.field_1352);
            this.method_36456(this.method_36454() + (float)this.angularVelocity.field_1351);
            this.setZRot(this.getZRot() + (float)this.angularVelocity.field_1350);
        }
        this.setParams();
    }

    public float method_49476() {
        return 1.0f;
    }

    private void setParams() {
        this.xAccum += this.getWrappedDelta(this.method_36455(), this.lastXRot);
        this.yAccum += this.getWrappedDelta(this.method_36454(), this.lastYRot);
        this.zAccum += this.getWrappedDelta(this.getZRot(), this.lastZRot);
        this.lastXRot = this.method_36455();
        this.lastYRot = this.method_36454();
        this.lastZRot = this.getZRot();
        this.rawXRotHistory[2] = this.rawXRotHistory[1];
        this.rawXRotHistory[1] = this.rawXRotHistory[0];
        this.rawXRotHistory[0] = this.xAccum;
        this.rawYRotHistory[2] = this.rawYRotHistory[1];
        this.rawYRotHistory[1] = this.rawYRotHistory[0];
        this.rawYRotHistory[0] = this.yAccum;
        this.rawZRotHistory[2] = this.rawZRotHistory[1];
        this.rawZRotHistory[1] = this.rawZRotHistory[0];
        this.rawZRotHistory[0] = this.zAccum;
    }

    private float getWrappedDelta(float current, float last) {
        return class_3532.method_15393((float)(current - last));
    }

    protected double getPhysicsSmoothing() {
        return 0.2;
    }

    protected double getAngularDrag() {
        return 0.92;
    }

    protected double getFriction() {
        return 0.96;
    }

    protected double getBounciness() {
        return 0.8;
    }

    protected double getPhysicsGravity() {
        return 0.15;
    }

    private double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public void method_5790() {
    }

    protected void method_5693() {
    }

    protected void method_5749(@NotNull class_2487 compound) {
    }

    protected void method_5652(@NotNull class_2487 compound) {
    }

    public void setAngularVelocity(class_243 angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public void setZRot(float zRot) {
        this.zRot = zRot;
    }

    public float getZRot() {
        return this.zRot;
    }

    public float getZRotOld() {
        return this.zRotOld;
    }
}

