/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.bad.JSActiveTimeGene;
import jp.jurassicsaga.server.base.generic.gene.obj.bad.JSInfertilityGene;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSAggressiveInstinct;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSBoneDensity;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSGenderLeanGene;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSIntensiveRepair;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSLightSkeleton;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSPlantData;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSSizeGene;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSSkinToughness;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSToothHardness;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSToxicSkinGene;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSVenomBiteGene;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import travelers.server.animal.obj.misc.AnimalType;

public class JSGenetics {
    public static final HashMap<JSGene, Supplier<class_1792>> GENE_ITEMS = new HashMap();
    public static final HashMap<class_2960, JSGene> GENE_REGISTRY = new HashMap();
    public static final Hashtable<class_1299<?>, JSDefaultEntityData> ENTITY_DEFAULT_GENE_DATA = new Hashtable();
    public static final Hashtable<String, JSPlantData> PLANT_GENETIC_INFORMATION = new Hashtable();
    public static final ArrayList<JSGene> DEFAULT_GENES = new ArrayList();
    public static final JSGene VIVID_COSMETIC = JSGenetics.register(JSCommon.createId("vivid"), new JSCosmeticGene(JSVariants.VIVID, 0xC3C3C3, 3214658));
    public static final JSGene ALPINE_COSMETIC = JSGenetics.register(JSCommon.createId("alpine"), new JSCosmeticGene(JSVariants.ALPINE, 15915443, 3287840));
    public static final JSGene FOREST_COSMETIC = JSGenetics.register(JSCommon.createId("forest"), new JSCosmeticGene(JSVariants.FOREST, 6117429, 1382661));
    public static final JSGene JUNGLE_COSMETIC = JSGenetics.register(JSCommon.createId("jungle"), new JSCosmeticGene(JSVariants.JUNGLE, 12413756, 4528917));
    public static final JSGene OCEAN_COSMETIC = JSGenetics.register(JSCommon.createId("ocean"), new JSCosmeticGene(JSVariants.OCEAN, 9861733, 11050910));
    public static final JSGene PASTURE_COSMETIC = JSGenetics.register(JSCommon.createId("pasture"), new JSCosmeticGene(JSVariants.PASTURE, 4998965, 3025429));
    public static final JSGene RAINFOREST_COSMETIC = JSGenetics.register(JSCommon.createId("rainforest"), new JSCosmeticGene(JSVariants.RAINFOREST, 8094063, 5002584));
    public static final JSGene RIVER_COSMETIC = JSGenetics.register(JSCommon.createId("river"), new JSCosmeticGene(JSVariants.RIVER, 7644505, 10042162));
    public static final JSGene SAVANNA_COSMETIC = JSGenetics.register(JSCommon.createId("savanna"), new JSCosmeticGene(JSVariants.SAVANNA, 4142384, 13869657));
    public static final JSGene STEPPE_COSMETIC = JSGenetics.register(JSCommon.createId("steppe"), new JSCosmeticGene(JSVariants.STEPPE, 3286302, 8274465));
    public static final JSGene TAIGA_COSMETIC = JSGenetics.register(JSCommon.createId("taiga"), new JSCosmeticGene(JSVariants.TAIGA, 3294510, 1446415));
    public static final JSGene TROPICAL_COSMETIC = JSGenetics.register(JSCommon.createId("tropical"), new JSCosmeticGene(JSVariants.TROPICAL, 8157495, 11238957));
    public static final JSGene TUNDRA_COSMETIC = JSGenetics.register(JSCommon.createId("tundra"), new JSCosmeticGene(JSVariants.TUNDRA, 0xB7B7B7, 0xFFFFFF));
    public static final JSGene ARID_COSMETIC = JSGenetics.register(JSCommon.createId("arid"), new JSCosmeticGene(JSVariants.ARID, 6308112, 16286504));
    public static final JSGene CHAOS_EFFECT_COSMETIC = JSGenetics.register(JSCommon.createId("chaos_effect"), new JSCosmeticGene(JSVariants.CHAOS_EFFECT, 13874244, 11612211));
    public static final JSGene SPECIAL_COSMETIC = JSGenetics.register(JSCommon.createId("special"), new JSCosmeticGene(JSVariants.SPECIAL, 0x161616, 12136182));
    public static final JSGene LEGACY_COSMETIC = JSGenetics.register(JSCommon.createId("legacy"), new JSCosmeticGene(JSVariants.LEGACY, 0x949494, 12262923));
    public static final JSGene LUX = JSGenetics.register(JSCommon.createId("lux"), new JSGene());
    public static final JSGene TOXIC_SKIN = JSGenetics.register(JSCommon.createId("toxic_skin"), new JSToxicSkinGene());
    public static final JSGene VENOM_BITE = JSGenetics.register(JSCommon.createId("venomous_bite"), new JSVenomBiteGene());
    public static final JSGene AGGRESSIVE_INSTINCT = JSGenetics.register(JSCommon.createId("aggresive_instinct"), new JSAggressiveInstinct());
    public static final JSGene BONE_DENSITY = JSGenetics.register(JSCommon.createId("bone_density"), new JSBoneDensity());
    public static final JSGene TOOTH_HARDNESS = JSGenetics.register(JSCommon.createId("tooth_hardness"), new JSToothHardness());
    public static final JSGene SKIN_TOUGHNESS = JSGenetics.register(JSCommon.createId("skin_toughness"), new JSSkinToughness());
    public static final JSGene LIGHT_SKELETON = JSGenetics.register(JSCommon.createId("lightweight_skeleton"), new JSLightSkeleton());
    public static final JSGene INTENSIVE_REPAIR = JSGenetics.register(JSCommon.createId("intensive_repair"), new JSIntensiveRepair());
    public static final JSGene IMMUNE_RESPONSE = JSGenetics.register(JSCommon.createId("immune_response"), new JSGene());
    public static final JSGene SIZE_SMALL = JSGenetics.register(JSCommon.createId("size_small"), new JSSizeGene(-0.1f, false));
    public static final JSGene SIZE_LARGE = JSGenetics.register(JSCommon.createId("size_large"), new JSSizeGene(0.1f, true));
    public static final JSGene GENDER_LEAN_FEMALE = JSGenetics.register(JSCommon.createId("gender_lean_female"), new JSGenderLeanGene(false));
    public static final JSGene GENDER_LEAN_MALE = JSGenetics.register(JSCommon.createId("gender_lean_male"), new JSGenderLeanGene(true));
    public static final JSGene INFERTILITY = JSGenetics.register(JSCommon.createId("infertility"), new JSInfertilityGene());
    public static final JSGene NOCTURNAL = JSGenetics.register(JSCommon.createId("nocturnal"), new JSActiveTimeGene(ActiveTime.NOCTURNAL));
    public static final JSGene CREPUSCULAR = JSGenetics.register(JSCommon.createId("crepuscular"), new JSActiveTimeGene(ActiveTime.CREPUSCULAR));
    public static final JSGene MATUTINAL = JSGenetics.register(JSCommon.createId("matutinal"), new JSActiveTimeGene(ActiveTime.MATUTINAL));
    public static final JSGene VESPERTINE = JSGenetics.register(JSCommon.createId("vespertine"), new JSActiveTimeGene(ActiveTime.VESPERTINE));
    public static final JSGene CATHEMERAL = JSGenetics.register(JSCommon.createId("cathemeral"), new JSActiveTimeGene(ActiveTime.CATHEMERAL));
    public static final JSGene ULTRADIAN = JSGenetics.register(JSCommon.createId("ultradian"), new JSActiveTimeGene(ActiveTime.ULTRADIAN));
    public static final JSGene LYSINE_DEFICIENCY = JSGenetics.register(JSCommon.createId("lysine_deficiency"), new JSGene());
    public static final JSGene FREQ_OVULATION = JSGenetics.register(JSCommon.createId("freq_ovulation"), new JSGene());
    public static final JSGene PARENTAL_INVESTMENT = JSGenetics.register(JSCommon.createId("parental_investment"), new JSGene());

    public static void init() {
        DEFAULT_GENES.add(SIZE_LARGE);
        DEFAULT_GENES.add(SIZE_SMALL);
        DEFAULT_GENES.add(VENOM_BITE);
        DEFAULT_GENES.add(TOXIC_SKIN);
        DEFAULT_GENES.add(BONE_DENSITY);
        DEFAULT_GENES.add(TOOTH_HARDNESS);
        DEFAULT_GENES.add(SKIN_TOUGHNESS);
        DEFAULT_GENES.add(AGGRESSIVE_INSTINCT);
        DEFAULT_GENES.add(IMMUNE_RESPONSE);
        DEFAULT_GENES.add(INTENSIVE_REPAIR);
        DEFAULT_GENES.add(LIGHT_SKELETON);
        DEFAULT_GENES.add(GENDER_LEAN_FEMALE);
        DEFAULT_GENES.add(GENDER_LEAN_MALE);
        DEFAULT_GENES.add(INFERTILITY);
        DEFAULT_GENES.add(NOCTURNAL);
        DEFAULT_GENES.add(CREPUSCULAR);
        DEFAULT_GENES.add(MATUTINAL);
        DEFAULT_GENES.add(VESPERTINE);
        DEFAULT_GENES.add(CATHEMERAL);
        DEFAULT_GENES.add(ULTRADIAN);
        JSGenetics.setDefault(class_1299.field_38384, AnimalType.FANTASY, AGGRESSIVE_INSTINCT);
        JSGenetics.setDefault(class_1299.field_6118, AnimalType.FISH, SKIN_TOUGHNESS);
        JSGenetics.setDefault(class_1299.field_40116, AnimalType.MAMMAL, ARID_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6085, AnimalType.MAMMAL, PASTURE_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6087, AnimalType.AQUATIC_MAMMAL, OCEAN_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6091, AnimalType.FANTASY, LIGHT_SKELETON);
        JSGenetics.setDefault(class_1299.field_17943, AnimalType.MAMMAL, TAIGA_COSMETIC);
        JSGenetics.setDefault(class_1299.field_28402, AnimalType.FISH, LUX);
        JSGenetics.setDefault(class_1299.field_30052, AnimalType.MAMMAL, ALPINE_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6074, AnimalType.MAMMAL, LYSINE_DEFICIENCY, STEPPE_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6084, AnimalType.FANTASY, VENOM_BITE);
        JSGenetics.setDefault(class_1299.field_6146, AnimalType.MAMMAL, PARENTAL_INVESTMENT);
        JSGenetics.setDefault(class_1299.field_6104, AnimalType.MAMMAL, RAINFOREST_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6042, AnimalType.MAMMAL, TUNDRA_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6140, AnimalType.MAMMAL, FREQ_OVULATION, FOREST_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6134, AnimalType.FANTASY, SIZE_LARGE);
        JSGenetics.setDefault(class_1299.field_6073, AnimalType.FISH, RIVER_COSMETIC);
        JSGenetics.setDefault(class_1299.field_6125, AnimalType.FANTASY, SIZE_SMALL);
        JSGenetics.setDefault(class_1299.field_6137, AnimalType.FANTASY, BONE_DENSITY);
        JSGenetics.setDefault(class_1299.field_42622, AnimalType.FANTASY, INTENSIVE_REPAIR);
        JSGenetics.setDefault(class_1299.field_6047, AnimalType.FANTASY, IMMUNE_RESPONSE);
        JSGenetics.setDefault(class_1299.field_6055, AnimalType.MAMMAL, TOOTH_HARDNESS);
        JSGenetics.setDefault(class_1299.field_37419, AnimalType.MAMMAL, GENDER_LEAN_FEMALE);
        JSGenetics.setDefault(class_1299.field_6070, AnimalType.MAMMAL, GENDER_LEAN_MALE);
        JSGenetics.addPlantGene("alethopteris", JSV1Blocks.ALETHOPTERIS, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cobbania_corrugata", JSV1Blocks.COBANNIA_CORRUGATA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cycadeoidea", JSV1Blocks.CYCADEOIDEA, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("neocalamites", JSV1Blocks.NEOCALAMITES, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("omphalophloios", JSV1Blocks.OMPHALOPHLOIOS, Era.CARBONIFEROUS);
        JSGenetics.addPlantGene("rhamnus_salicifolius", JSV1Blocks.RHAMNUS_SALICIFOLIUS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("selaginellites", JSV1Blocks.SELAGINELLITES, Era.CRETACEOUS);
        JSGenetics.addPlantGene("veriformans", JSV1Blocks.VERIFORMANS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("tempskya", JSV1Blocks.TEMPSKYA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_basic", JSV1Blocks.ZINGIBEROPSIS_BASIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_orange", JSV1Blocks.ZINGIBEROPSIS_ORANGE, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_pink", JSV1Blocks.ZINGIBEROPSIS_PINK, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_red", JSV1Blocks.ZINGIBEROPSIS_RED, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_white", JSV1Blocks.ZINGIBEROPSIS_WHITE, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_yellow", JSV1Blocks.ZINGIBEROPSIS_YELLOW, Era.CRETACEOUS);
        JSGenetics.addPlantGene("caprina", JSV1Blocks.CAPRINA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("hippuritella", JSV1Blocks.HIPPURITELLA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cremnoceramus", JSV1Blocks.CREMNOCERAMUS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("inoceramus", JSV1Blocks.INOCERAMUS, Era.CRETACEOUS, Era.JURASSIC);
        JSGenetics.addPlantGene("lepidodendron_sapling", JSV1Blocks.LEPIDODENDRON_SAPLING, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC);
        JSGenetics.addPlantGene("spinifructus_sapling", JSV1Blocks.SPINIFRUCTUS_SAPLING, Era.CRETACEOUS);
        JSGenetics.addPlantGene("araucarioxylon_sapling", JSV1Blocks.ARAUCARIOXYLON_SAPLING, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CARBONIFEROUS, Era.PALEOGENE);
        JSGenetics.addPlantGene("gordonopteris_sapling", JSV1Blocks.GORDONPTERIS_SAPLING, Era.TRIASSIC);
        JSGenetics.addPlantGene("brasenites_kansense_basic", JSV2Blocks.BRASENITES_KANSENSE_BASIC, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_blue", JSV2Blocks.BRASENITES_KANSENSE_BLUE, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_lightblue", JSV2Blocks.BRASENITES_KANSENSE_LIGHTBLUE, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_magenta", JSV2Blocks.BRASENITES_KANSENSE_MAGENTA, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_orange", JSV2Blocks.BRASENITES_KANSENSE_ORANGE, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_pink", JSV2Blocks.BRASENITES_KANSENSE_PINK, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_red", JSV2Blocks.BRASENITES_KANSENSE_RED, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_yellow", JSV2Blocks.BRASENITES_KANSENSE_YELLOW, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("montsechia", JSV2Blocks.MONTSECHIA, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("nathorstiana", JSV2Blocks.NATHORSTIANA, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("orontium_mackii", JSV2Blocks.ORONTIUM_MACKII, Versions.VERSION_4, Era.CRETACEOUS);
        JSGenetics.addPlantGene("dicksonia", JSV2Blocks.DICKSONIA, Versions.VERSION_4, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS, Era.PALEOGENE, Era.NEOGENE, Era.QUATERNARY);
        JSGenetics.addPlantGene("dicroidium", JSV2Blocks.DICROIDIUM, Versions.VERSION_4, Era.TRIASSIC);
        JSGenetics.addPlantGene("zamites", JSV2Blocks.ZAMITES, Versions.VERSION_4, Era.TRIASSIC);
        JSGenetics.addPlantGene("williamsonia", JSV2Blocks.WILLIAMSONIA, Versions.VERSION_4, Era.TRIASSIC);
        JSGenetics.addPlantGene("gondwanagaricites", JSV2Blocks.GONDWANAGARICITES, Versions.VERSION_4, Era.TRIASSIC);
        JSGenetics.addPlantGene("pleuromeia", JSV2Blocks.PLEUROMEIA, Versions.VERSION_4, Era.TRIASSIC);
    }

    private static void addPlantGene(String plantCode, Supplier<class_2248> completionResult, Era ... eras) {
        JSGeneData geneData = new JSGeneData();
        if (plantCode.contains(":")) {
            geneData.setDataOwnerName(plantCode);
        } else {
            geneData.setDataOwnerName("jurassicsaga:" + plantCode);
        }
        geneData.setBaseQuality(100);
        geneData.setGeneType(GeneType.PLANT);
        PLANT_GENETIC_INFORMATION.put(plantCode, new JSPlantData(JSItems.registerItem(plantCode + "_coin", (Supplier<class_1792>)((Supplier)() -> new PlantDnaItem(plantCode, geneData))), completionResult, eras));
    }

    private static void addPlantGene(String plantCode, Supplier<class_2248> completionResult, Versions.Version version, Era ... eras) {
        JSGeneData geneData = new JSGeneData();
        if (plantCode.contains(":")) {
            geneData.setDataOwnerName(plantCode);
        } else {
            geneData.setDataOwnerName("jurassicsaga:" + plantCode);
        }
        geneData.setBaseQuality(100);
        geneData.setGeneType(GeneType.PLANT);
        PLANT_GENETIC_INFORMATION.put(plantCode, new JSPlantData(JSItems.registerItem(plantCode + "_coin", (Supplier<class_1792>)((Supplier)() -> new PlantDnaItem(plantCode, geneData))), completionResult, version, eras));
    }

    private static void setDefault(class_1299<?> type, AnimalType animalType, JSGene ... genes) {
        if (genes.length == 0 || type == null) {
            return;
        }
        JSGeneData geneData = new JSGeneData();
        class_2960 key = class_7923.field_41177.method_10221(type);
        geneData.setDataOwnerName(key.toString());
        geneData.setBaseQuality(100);
        geneData.addGenes(genes);
        ENTITY_DEFAULT_GENE_DATA.put(type, new JSDefaultEntityData(geneData, animalType, JSItems.registerItem(key.method_12832() + "_default", (Supplier<class_1792>)((Supplier)() -> new OtherDnaItem(type, geneData, new class_1792.class_1793())))));
    }

    public static <T extends JSGene> T register(class_2960 location, T gene) {
        gene.setRegisteredLocation(location);
        GENE_REGISTRY.put(location, gene);
        GENE_ITEMS.put(gene, JSItems.registerItem(location.method_12832(), (Supplier<class_1792>)((Supplier)() -> new GeneItem(gene, new class_1792.class_1793()))));
        return gene;
    }

    public static JSGene getGene(class_2960 location) {
        return GENE_REGISTRY.get(location);
    }

    public static JSGene getRandomBadGene() {
        ArrayList<JSGene> geneList = new ArrayList<JSGene>();
        for (JSGene value : GENE_REGISTRY.values()) {
            if (value.getToolTipColour() != class_124.field_1061) continue;
            geneList.add(value);
        }
        Optional value = geneList.stream().findAny();
        return value.orElse(NOCTURNAL);
    }
}

