/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.recipe.craftingtable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.item.obj.InfertilePlantItem;
import jp.jurassicsaga.server.base.item.obj.egg.InfertileEggItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneticsItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.base.recipe.JSRecipes;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class FertilizedEggRecipe
extends class_1867 {
    public FertilizedEggRecipe(String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients) {
        super(JSCommon.createId("fertilized_egg"), group, category, result, ingredients);
    }

    public boolean method_17730(class_8566 input, @NotNull class_1937 level) {
        class_1662 stackedcontents = new class_1662();
        int size = 0;
        for (int j = 0; j < input.method_5439(); ++j) {
            class_1799 itemstack = input.method_5438(j);
            if (itemstack.method_7960()) continue;
            ++size;
            stackedcontents.method_20478(itemstack, 1);
        }
        if (size != 3) {
            return false;
        }
        if (level.field_9236) {
            return false;
        }
        boolean hasSyringe = false;
        boolean hasEgg = false;
        boolean hasDna = false;
        for (int i = 0; i < input.method_5439(); ++i) {
            class_1799 stack = input.method_5438(i);
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            if (item == JSV1Items.SYRINGE.get()) {
                hasSyringe = true;
                continue;
            }
            if (item instanceof InfertileEggItem || item instanceof InfertilePlantItem) {
                hasEgg = true;
                continue;
            }
            if (!(item instanceof GeneticsItem) || !(item instanceof DnaItem) && !(item instanceof PlantDnaItem)) continue;
            hasDna = true;
        }
        return hasSyringe && hasEgg && hasDna;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_49188() {
        return false;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)JSRecipes.FERTILIZED_EGG_SERIALIZER.get();
    }

    @NotNull
    public class_1799 method_17729(@NotNull class_8566 inv, @NotNull class_5455 registryAccess) {
        class_1799 item;
        class_1799 coin = null;
        class_1799 egg = null;
        JSAnimal<?> animal = null;
        class_1799 result = null;
        boolean isEmpty = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1792 class_17922;
            item = inv.method_5438(i);
            if (item.method_7909() instanceof SyringeItem && !isEmpty) {
                class_2487 tag = item.method_7969();
                int cmd = 0;
                if (tag != null && tag.method_10573("CustomModelData", 3)) {
                    cmd = tag.method_10550("CustomModelData");
                }
                boolean bl = isEmpty = cmd == 0;
            }
            if ((class_17922 = item.method_7909()) instanceof DnaItem) {
                DnaItem dna = (DnaItem)class_17922;
                coin = item;
                animal = dna.getAnimal();
                continue;
            }
            class_17922 = item.method_7909();
            if (class_17922 instanceof PlantDnaItem) {
                PlantDnaItem plantDnaItem = (PlantDnaItem)class_17922;
                coin = item;
                result = ((class_2248)JSGenetics.PLANT_GENETIC_INFORMATION.get((Object)plantDnaItem.getHolderName()).result.get()).method_8389().method_7854();
                continue;
            }
            if (!item.method_31573(JSItemTags.UNFERTILIZED_EGGS)) continue;
            egg = item;
        }
        if (coin == null || egg == null || !isEmpty) {
            return class_1799.field_8037;
        }
        item = egg.method_7909();
        if (item instanceof InfertileEggItem) {
            InfertileEggItem item2 = (InfertileEggItem)item;
            if (animal == null) {
                return class_1799.field_8037;
            }
            if (item2.getEggType() == animal.getAnimalAttributes().getItemProperties().getEggtype()) {
                eggCopy = item2.getFertileVersion().method_7854();
                genData = JSGeneUtil.readFromStack(coin);
                JSGeneUtil.writeToStack(eggCopy, genData);
                return eggCopy;
            }
        } else if (egg.method_7909() instanceof InfertilePlantItem) {
            if (result == null) {
                return class_1799.field_8037;
            }
            eggCopy = ((class_1792)JSV1Items.SEEDS_FERTILIZED.get()).method_7854();
            genData = JSGeneUtil.readFromStack(coin);
            genData.setGeneType(GeneType.PLANT);
            JSGeneUtil.writeToStack(eggCopy, genData);
            return eggCopy;
        }
        return class_1799.field_8037;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        class_2371 remaining = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 item = inv.method_5438(i);
            if (!(item.method_7909() instanceof SyringeItem)) continue;
            class_1799 stack = ((class_1792)JSV1Items.SYRINGE.get()).method_7854();
            stack.method_7948().method_10569("CustomModelData", 1);
            remaining.set(i, (Object)stack);
        }
        return remaining;
    }

    public static class Serializer
    implements class_1865<FertilizedEggRecipe> {
        @NotNull
        public FertilizedEggRecipe fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_7710 category = (class_7710)class_7710.field_40252.method_42633(class_3518.method_15253((JsonObject)json, (String)"category", (String)"misc"));
            JsonArray ingredientsArray = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_2371<class_1856> ingredients = Serializer.itemsFromJson(ingredientsArray);
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
            }
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new FertilizedEggRecipe(group, category, result, ingredients);
        }

        private static class_2371<class_1856> itemsFromJson(JsonArray array) {
            class_2371 list = class_2371.method_10211();
            for (int i = 0; i < array.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)array.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        @NotNull
        public FertilizedEggRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
            String group = buf.method_19772();
            class_7710 category = (class_7710)buf.method_10818(class_7710.class);
            int count = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)count, (Object)class_1856.field_9017);
            for (int i = 0; i < count; ++i) {
                ingredients.set(i, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1799 result = buf.method_10819();
            return new FertilizedEggRecipe(group, category, result, (class_2371<class_1856>)ingredients);
        }

        public void toNetwork(@NotNull class_2540 buf, @NotNull FertilizedEggRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817((Enum)recipe.method_45441());
            class_2371 ingredients = recipe.method_8117();
            buf.method_10804(ingredients.size());
            for (class_1856 ingredient : ingredients) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(recipe.method_8110((class_5455)class_5455.field_40585));
        }
    }
}

