/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.world.biome.JSBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;

public final class JSBiomeBuilder {
    private static final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    private static final class_6544.class_6546[] TEMPS = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private static final class_6544.class_6546[] HUMS = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    private static final class_6544.class_6546[] EROS = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private static final class_6544.class_6546 FROZEN_RANGE = TEMPS[0];
    private static final class_6544.class_6546 UNFROZEN_RANGE = class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[1], (class_6544.class_6546)TEMPS[4]);
    private static final class_6544.class_6546 MUSHROOM_C = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
    private static final class_6544.class_6546 DEEP_OCEAN_C = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
    private static final class_6544.class_6546 OCEAN_C = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
    private static final class_6544.class_6546 COAST_C = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
    private static final class_6544.class_6546 INLAND_C = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
    private static final class_6544.class_6546 NEAR_INLAND_C = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
    private static final class_6544.class_6546 MID_INLAND_C = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
    private static final class_6544.class_6546 FAR_INLAND_C = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
    private static final class_5321<class_1959>[][] OCEANS = new class_5321[][]{{class_1972.field_9418, class_1972.field_9470, class_1972.field_9446, class_1972.field_9439, class_1972.field_9408}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, class_1972.field_9441, class_1972.field_9408}};
    private static final class_5321<class_1959>[][] MIDDLE = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9420, class_1972.field_9420}, {class_1972.field_9451, class_1972.field_9451, class_1972.field_9409, class_1972.field_9420, class_1972.field_9420}, {class_1972.field_9414, class_1972.field_9451, JSBiomes.BURNT_FOREST.getBiomeKey(), class_1972.field_9412, class_1972.field_9475}, {JSBiomes.SULPHUR_SPRINGS.getBiomeKey(), JSBiomes.SULPHUR_SPRINGS.getBiomeKey(), class_1972.field_9409, class_1972.field_9417, class_1972.field_9417}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}};
    private static final class_5321<class_1959>[][] MIDDLE_VAR = new class_5321[][]{{class_1972.field_9453, null, class_1972.field_9420, null, null}, {null, null, null, null, class_1972.field_9420}, {JSBiomes.TALL_GRASS_PLAINS.getBiomeKey(), null, null, class_1972.field_35112, null}, {null, null, JSBiomes.TALL_GRASS_PLAINS.getBiomeKey(), class_1972.field_35118, class_1972.field_9440}, {null, null, null, null, null}};
    private static final class_5321<class_1959>[][] PLATEAU = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9454}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_9409, class_1972.field_9420, class_1972.field_9420}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_9475}, {class_1972.field_9430, class_1972.field_9430, class_1972.field_9409, class_1972.field_9409, class_1972.field_9417}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}};
    private static final class_5321<class_1959>[][] PLATEAU_VAR = new class_5321[][]{{class_1972.field_9453, null, null, null, null}, {class_1972.field_42720, null, class_1972.field_34470, class_1972.field_34470, class_1972.field_9420}, {class_1972.field_42720, class_1972.field_42720, class_1972.field_9409, class_1972.field_9412, null}, {null, null, null, null, null}, {class_1972.field_9443, class_1972.field_9443, null, null, null}};
    private static final class_5321<class_1959>[][] SHATTERED = new class_5321[][]{{class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35116, class_1972.field_35116, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final Map<class_5321<class_1959>, WeightBag<class_5321<class_1959>>> rarityPools = new HashMap<class_5321<class_1959>, WeightBag<class_5321<class_1959>>>();
    private long raritySalt = 0L;

    public JSBiomeBuilder setRaritySeed(long seed) {
        this.raritySalt = seed;
        return this;
    }

    public JSBiomeBuilder addVariant(class_5321<class_1959> base, class_5321<class_1959> variant, int weight) {
        if (weight <= 0) {
            return this;
        }
        this.rarityPools.computeIfAbsent(base, k -> new WeightBag()).add(base, 1).add(variant, weight);
        return this;
    }

    public List<class_6544.class_4762> spawnTarget() {
        class_6544.class_6546 y = class_6544.class_6546.method_38120((float)0.0f);
        float weirdCut = 0.16f;
        return List.of(new class_6544.class_4762(FULL_RANGE, FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)INLAND_C, (class_6544.class_6546)FULL_RANGE), FULL_RANGE, y, class_6544.class_6546.method_38121((float)-1.0f, (float)(-weirdCut)), 0L), new class_6544.class_4762(FULL_RANGE, FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)INLAND_C, (class_6544.class_6546)FULL_RANGE), FULL_RANGE, y, class_6544.class_6546.method_38121((float)weirdCut, (float)1.0f), 0L));
    }

    public void addBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out) {
        this.addOffCoastBiomes(out);
        this.addInlandBiomes(out);
        this.addUndergroundBiomes(out);
    }

    private void addOffCoastBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, MUSHROOM_C, FULL_RANGE, FULL_RANGE, 0.0f, (class_5321<class_1959>)class_1972.field_9462);
        for (int ti = 0; ti < TEMPS.length; ++ti) {
            class_6544.class_6546 t = TEMPS[ti];
            this.emitSurface(out, t, FULL_RANGE, DEEP_OCEAN_C, FULL_RANGE, FULL_RANGE, 0.0f, OCEANS[0][ti]);
            this.emitSurface(out, t, FULL_RANGE, OCEAN_C, FULL_RANGE, FULL_RANGE, 0.0f, OCEANS[1][ti]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out) {
        this.addMidSlice(out, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(out, class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(out, class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(out, class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(out, class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(out, class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f));
        this.addValleys(out, class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f));
        this.addLowSlice(out, class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f));
        this.addMidSlice(out, class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f));
        this.addHighSlice(out, class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f));
        this.addPeaks(out, class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(out, class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(out, class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 d) {
        this.grid((ti, hi) -> {
            class_6544.class_6546 T = TEMPS[ti];
            class_6544.class_6546 H = HUMS[hi];
            class_5321<class_1959> mid = this.pickMiddle(ti, hi, d);
            class_5321<class_1959> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            class_5321<class_1959> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            class_5321<class_1959> plat = this.pickPlateau(ti, hi, d);
            class_5321<class_1959> shat = this.pickShattered(ti, hi, d);
            class_5321<class_1959> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, shat);
            class_5321<class_1959> peak = this.pickPeak(ti, hi, d);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[0], d, 0.0f, peak);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[1], d, 0.0f, peak);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[3], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[3], d, 0.0f, plat);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
        });
    }

    private void addHighSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 d) {
        this.grid((ti, hi) -> {
            class_6544.class_6546 T = TEMPS[ti];
            class_6544.class_6546 H = HUMS[hi];
            class_5321<class_1959> mid = this.pickMiddle(ti, hi, d);
            class_5321<class_1959> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            class_5321<class_1959> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            class_5321<class_1959> plat = this.pickPlateau(ti, hi, d);
            class_5321<class_1959> shat = this.pickShattered(ti, hi, d);
            class_5321<class_1959> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            class_5321<class_1959> slope = this.pickSlope(ti, hi, d);
            class_5321<class_1959> peak = this.pickPeak(ti, hi, d);
            this.emitSurface(out, T, H, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, mid);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[0], d, 0.0f, slope);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[0], d, 0.0f, peak);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[1], d, 0.0f, slope);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[3], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[3], d, 0.0f, plat);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
        });
    }

    private void addMidSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 d) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[2]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[1], (class_6544.class_6546)TEMPS[2]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[3], (class_6544.class_6546)TEMPS[4]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        this.grid((ti, hi) -> {
            class_6544.class_6546 T = TEMPS[ti];
            class_6544.class_6546 H = HUMS[hi];
            class_5321<class_1959> mid = this.pickMiddle(ti, hi, d);
            class_5321<class_1959> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            class_5321<class_1959> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            class_5321<class_1959> shat = this.pickShattered(ti, hi, d);
            class_5321<class_1959> plat = this.pickPlateau(ti, hi, d);
            class_5321<class_1959> beach = this.pickBeach(ti, hi);
            class_5321<class_1959> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            class_5321<class_1959> shCoast = this.pickShatteredCoast(ti, hi, d);
            class_5321<class_1959> slope = this.pickSlope(ti, hi, d);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[0], d, 0.0f, slope);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)MID_INLAND_C), EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[1], d, 0.0f, ti == 0 ? slope : plat);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[2], d, 0.0f, mid);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[2], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)NEAR_INLAND_C), EROS[3], d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[3], d, 0.0f, midHot);
            if (d.comp_104() < 0L) {
                this.emitSurface(out, T, H, COAST_C, EROS[4], d, 0.0f, beach);
                this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            } else {
                this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            }
            this.emitSurface(out, T, H, COAST_C, EROS[5], d, 0.0f, shCoast);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            if (d.comp_104() < 0L) {
                this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, beach);
            } else {
                this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, mid);
            }
            if (ti == 0) {
                this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
            }
        });
    }

    private void addLowSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 d) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[2]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[1], (class_6544.class_6546)TEMPS[2]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[3], (class_6544.class_6546)TEMPS[4]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        this.grid((ti, hi) -> {
            class_6544.class_6546 T = TEMPS[ti];
            class_6544.class_6546 H = HUMS[hi];
            class_5321<class_1959> mid = this.pickMiddle(ti, hi, d);
            class_5321<class_1959> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            class_5321<class_1959> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            class_5321<class_1959> beach = this.pickBeach(ti, hi);
            class_5321<class_1959> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            class_5321<class_1959> shCoast = this.pickShatteredCoast(ti, hi, d);
            this.emitSurface(out, T, H, NEAR_INLAND_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, midHot);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, NEAR_INLAND_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[3]), d, 0.0f, midHot);
            this.emitSurface(out, T, H, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[3], (class_6544.class_6546)EROS[4]), d, 0.0f, beach);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, COAST_C, EROS[5], d, 0.0f, shCoast);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[5], d, 0.0f, mid);
            this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, beach);
            if (ti == 0) {
                this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)NEAR_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
            }
        });
    }

    private void addValleys(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 d) {
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, (class_5321<class_1959>)(d.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9463));
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, COAST_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, (class_5321<class_1959>)(d.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9438));
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, NEAR_INLAND_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, NEAR_INLAND_C, class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[5]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)COAST_C, (class_6544.class_6546)FAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[2], (class_6544.class_6546)EROS[5]), d, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, COAST_C, EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, COAST_C, EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[1], (class_6544.class_6546)TEMPS[2]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.emitSurface(out, class_6544.class_6546.method_38123((class_6544.class_6546)TEMPS[3], (class_6544.class_6546)TEMPS[4]), FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)INLAND_C, (class_6544.class_6546)FAR_INLAND_C), EROS[6], d, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.grid((ti, hi) -> {
            class_6544.class_6546 T = TEMPS[ti];
            class_6544.class_6546 H = HUMS[hi];
            class_5321<class_1959> midOrBad = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            this.emitSurface(out, T, H, class_6544.class_6546.method_38123((class_6544.class_6546)MID_INLAND_C, (class_6544.class_6546)FAR_INLAND_C), class_6544.class_6546.method_38123((class_6544.class_6546)EROS[0], (class_6544.class_6546)EROS[1]), d, 0.0f, midOrBad);
        });
    }

    private void addUndergroundBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out) {
    }

    private class_5321<class_1959> pickMiddle(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = d.comp_104() < 0L ? MIDDLE[t][h] : Optional.ofNullable(MIDDLE_VAR[t][h]).orElse(MIDDLE[t][h]);
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> pickMiddleOrBadlandsIfHot(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = t == 4 ? this.pickBadlands(h, d) : this.pickMiddle(t, h, d);
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> pickMiddleOrBadlandsIfHotOrSlopeIfCold(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = t == 0 ? this.pickSlope(t, h, d) : this.pickMiddleOrBadlandsIfHot(t, h, d);
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> maybeWindsweptSavanna(int t, int h, class_6544.class_6546 d, class_5321<class_1959> fallback) {
        class_5321 base = t > 1 && h < 4 && d.comp_104() >= 0L ? class_1972.field_35114 : fallback;
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> pickShatteredCoast(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = d.comp_104() >= 0L ? this.pickMiddle(t, h, d) : this.pickBeach(t, h);
        base = this.maybeWindsweptSavanna(t, h, d, base);
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> pickBeach(int t, int h) {
        if (t == 0) {
            return class_1972.field_9478;
        }
        return t == 4 ? class_1972.field_9424 : class_1972.field_9434;
    }

    private class_5321<class_1959> pickBadlands(int h, class_6544.class_6546 d) {
        if (h < 2) {
            return d.comp_104() < 0L ? class_1972.field_9415 : class_1972.field_9443;
        }
        return h < 3 ? class_1972.field_9415 : class_1972.field_35110;
    }

    private class_5321<class_1959> pickPlateau(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = d.comp_104() >= 0L && PLATEAU_VAR[t][h] != null ? PLATEAU_VAR[t][h] : PLATEAU[t][h];
        return this.withRarity(base, t, h, d);
    }

    private class_5321<class_1959> pickPeak(int t, int h, class_6544.class_6546 d) {
        Object base = t <= 2 ? (d.comp_104() < 0L ? class_1972.field_34474 : class_1972.field_35115) : (t == 3 ? class_1972.field_34475 : this.pickBadlands(h, d));
        return this.withRarity((class_5321<class_1959>)base, t, h, d);
    }

    private class_5321<class_1959> pickSlope(int t, int h, class_6544.class_6546 d) {
        Object base = t >= 3 ? this.pickPlateau(t, h, d) : (h <= 1 ? class_1972.field_34472 : class_1972.field_34471);
        return this.withRarity((class_5321<class_1959>)base, t, h, d);
    }

    private class_5321<class_1959> pickShattered(int t, int h, class_6544.class_6546 d) {
        class_5321<class_1959> base = Optional.ofNullable(SHATTERED[t][h]).orElse(this.pickMiddle(t, h, d));
        return this.withRarity(base, t, h, d);
    }

    private void emitSurface(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 T, class_6544.class_6546 H, class_6544.class_6546 C, class_6544.class_6546 E, class_6544.class_6546 D, float W, class_5321<class_1959> key) {
        class_5321<class_1959> k = key;
        class_6544.class_4762 p1 = class_6544.method_38118((class_6544.class_6546)T, (class_6544.class_6546)H, (class_6544.class_6546)C, (class_6544.class_6546)E, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)D, (float)W);
        class_6544.class_4762 p2 = class_6544.method_38118((class_6544.class_6546)T, (class_6544.class_6546)H, (class_6544.class_6546)C, (class_6544.class_6546)E, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)D, (float)W);
        out.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)p1, k));
        out.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)p2, k));
    }

    private void emitUnderground(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> out, class_6544.class_6546 T, class_6544.class_6546 H, class_6544.class_6546 C, class_6544.class_6546 E, class_6544.class_6546 D, float W, class_5321<class_1959> key) {
        class_6544.class_4762 p = class_6544.method_38118((class_6544.class_6546)T, (class_6544.class_6546)H, (class_6544.class_6546)C, (class_6544.class_6546)E, (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.2f, (float)0.9f), (class_6544.class_6546)D, (float)W);
        out.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)p, key));
    }

    private void grid(Cell cell) {
        for (int ti = 0; ti < TEMPS.length; ++ti) {
            for (int hi = 0; hi < HUMS.length; ++hi) {
                cell.accept(ti, hi);
            }
        }
    }

    private class_5321<class_1959> withRarity(class_5321<class_1959> base, int t, int h, class_6544.class_6546 d) {
        WeightBag<class_5321<class_1959>> bag = this.rarityPools.get(base);
        if (bag == null) {
            return base;
        }
        long hash = JSBiomeBuilder.mix(this.raritySalt, t, h, d.comp_103(), d.comp_104());
        return bag.pick(hash);
    }

    private static long mix(long salt, int t, int h, long dMin, long dMax) {
        long x = salt ^ 0x9E3779B97F4A7C15L;
        x ^= (long)t * -4658895280553007687L;
        x ^= (long)h * -7723592293110705685L;
        x ^= (dMin & 0xFFFFL) * 2685821657736338717L;
        return (x ^= (dMax & 0xFFFFL) * 1311768467294899695L) == 0L ? 1L : x;
    }

    private static final class WeightBag<T> {
        private final List<T> items = new ArrayList<T>();
        private final List<Integer> cum = new ArrayList<Integer>();
        private int total = 0;

        private WeightBag() {
        }

        WeightBag<T> add(T item, int w) {
            if (w <= 0) {
                return this;
            }
            this.total += w;
            this.items.add(item);
            this.cum.add(this.total);
            return this;
        }

        T pick(long seed) {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Empty weight bag");
            }
            if (this.items.size() == 1) {
                return this.items.get(0);
            }
            long r = WeightBag.nextPositive(seed) % (long)this.total;
            int idx = Collections.binarySearch(this.cum, (int)r + 1);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return this.items.get(idx);
        }

        private static long nextPositive(long x) {
            x ^= x << 13;
            x ^= x >>> 7;
            x ^= x << 17;
            return x & Long.MAX_VALUE;
        }
    }

    private static interface Cell {
        public void accept(int var1, int var2);
    }
}

