/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.AlligatorAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class AlligatorAnimal
extends AbstractJSAnimal<AlligatorEntity> {
    public AlligatorAnimal() {
        super("alligator");
        this.setAnimator(new AlligatorAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<AlligatorEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(5.0f));
        geneticProperties.setDefaultGenes(JSGenetics.TROPICAL_COSMETIC);
        geneticProperties.setSpawnGeneticsDefault();
        geneticProperties.addSupportedGenes(JSGenetics.SIZE_SMALL, JSGenetics.SIZE_LARGE);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<AlligatorEntity> metabolismProperties) {
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, () -> Diets.CARNIVORE.get().add(Diets.PISCIVORE.get()));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<AlligatorEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.addBiomeTarget("swamp", 3, 2, 5, class_1311.field_6300, (class_6862<class_1959>)class_6908.field_36495);
        miscProperties.setSpawnPlacementType(class_1317.class_1319.field_6318);
        miscProperties.setSpawnHeightMap(class_2902.class_2903.field_13200);
        miscProperties.setSpawnPredicate((class_1317.class_4306<AlligatorEntity>)((class_1317.class_4306)AlligatorEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<AlligatorEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, MesolimulusEntity.class, class_1422.class, class_1429.class, GoatEntity.class, OstrichEntity.class, GallimimusEntity.class, DryosaurusEntity.class, ProcompsognathusEntity.class, BonitoEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, CompsognathusEntity.class, MicroceratusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addScaredOf(TylosaurusEntity.class);
        socialGroupProperties.addHerdTargets(AlligatorEntity.class);
        socialGroupProperties.setMaxHerdSize(6);
        socialGroupProperties.enableNesting();
        socialGroupProperties.setNaturalAggression(1.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<AlligatorEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(7563332, 4142898);
        itemProperties.setSpawnEggColorsMale(7036477, 2960168);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<AlligatorEntity> attributes, EntityBaseProperties<AlligatorEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setTurnSmoothRate((double)0.4f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(1.0);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setEntityFactory(AlligatorEntity::new);
        attributes.setCategory(class_1311.field_6300);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(16.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions((double)1.6f, (double)0.7f);
        attributes.setMovementSpeed((double)0.16f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)1.6f);
        attributes.setWaterEfficiency(1.0);
    }
}

