/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSVariantLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.animal.animations.extant.BonitoAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class BonitoAnimal
extends AbstractJSAnimal<BonitoEntity> {
    public BonitoAnimal() {
        super("bonito");
        this.setAnimator(new BonitoAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<BonitoEntity> geneticProperties) {
        geneticProperties.setSpawnGeneticsDefault();
        geneticProperties.setDefaultGenes(JSGenetics.VIVID_COSMETIC);
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<BonitoEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<BonitoEntity> miscProperties) {
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
        miscProperties.addBiomeTarget("ocean", 4, 3, 8, class_1311.field_6300, (class_6862<class_1959>)class_6908.field_36509);
        miscProperties.setSpawnPlacementType(class_1317.class_1319.field_6318);
        miscProperties.setSpawnHeightMap(class_2902.class_2903.field_13200);
        miscProperties.setSpawnPredicate((class_1317.class_4306<BonitoEntity>)((class_1317.class_4306)BonitoEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<BonitoEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(AlligatorEntity.class, TylosaurusEntity.class, class_1657.class);
        socialGroupProperties.addHerdTargets(BonitoEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(500.0f);
        socialGroupProperties.setMinDistanceToPackLeader(20.0f);
        socialGroupProperties.setMaxHerdSize(7);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<BonitoEntity> itemProperties) {
        itemProperties.setSpawnEggColorsMale(750740, 14010249);
        itemProperties.setSpawnEggColors(2727103, 12101995);
        itemProperties.setBucketable();
        itemProperties.enableCoin();
        itemProperties.disableEgg();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<BonitoEntity> attributes, EntityBaseProperties<BonitoEntity> base) {
        base.setAnimalType(AnimalType.FISH);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(54.0);
        base.setTurnSmoothRate((double)0.8f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.25);
        base.setLocator(new JSVariantLocator());
        attributes.setEntityFactory(BonitoEntity::new);
        attributes.setCategory(class_1311.field_24460);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(4.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions(0.5, (double)0.4f);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setRunningSpeedMultiplier((double)1.65f);
        attributes.setSwimmingSpeedMultiplier((double)1.2f);
        attributes.setWaterEfficiency(1.25);
    }
}

