/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSGenderTextureLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.GoatAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class GoatAnimal
extends AbstractJSAnimal<GoatEntity> {
    public GoatAnimal() {
        super("goat");
        this.setAnimator(new GoatAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<GoatEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(7.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(3.0f));
        geneticProperties.setDefaultGenes(JSGenetics.ALPINE_COSMETIC);
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<GoatEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.SEEDS);
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<GoatEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.addBiomeTarget("overworld", 12, 2, 4, class_1311.field_6294, (class_6862<class_1959>)class_6908.field_37393);
        miscProperties.setSpawnPlacementType(class_1317.class_1319.field_6317);
        miscProperties.setSpawnHeightMap(class_2902.class_2903.field_13203);
        miscProperties.setSpawnPredicate((class_1317.class_4306<GoatEntity>)((class_1317.class_4306)GoatEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<GoatEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(12);
        socialGroupProperties.setMaxDistanceToPackLeader(2000.0f);
        socialGroupProperties.setMinDistanceToPackLeader(64.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<GoatEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.disableEgg();
        itemProperties.setSpawnEggColors(15261902, 2497815);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<GoatEntity> attributes, EntityBaseProperties<GoatEntity> base) {
        base.setAnimalType(AnimalType.MAMMAL);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.5);
        base.setTurnSmoothRate((double)0.7f);
        base.setLocator((ResourceLocator)new JSGenderTextureLocator<GoatEntity>(){

            @Override
            public class_2960 getTextureLocation(GoatEntity entity) {
                String type = entity.getGoatVariant().getTypeName();
                String key = this.makeKey(entity, "texture:" + type, entity.getModules().getGeneticModule().isMale());
                try {
                    return (class_2960)this.cache.get((Object)key, () -> {
                        String gender;
                        String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                        String version = this.getVersion(entity);
                        String string = gender = entity.getModules().getGeneticModule().isMale() ? "male" : "female";
                        if (entity.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                            return new class_2960("jurassicsaga", "textures/geo/animal/" + version + "/" + name + "/" + name + "_" + type + "_baby.png");
                        }
                        return new class_2960("jurassicsaga", "textures/geo/animal/" + version + "/" + name + "/" + name + "_" + type + "_" + gender + ".png");
                    });
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        attributes.setEntityFactory(GoatEntity::new);
        attributes.setCategory(class_1311.field_6294);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(10.0);
        attributes.setAttackDamage(9.0);
        attributes.setAttackSpeed(1.0);
        attributes.setWaterEfficiency(1.0);
        attributes.setSpawnFar();
        attributes.setDimensions((double)0.85f, (double)0.85f);
        attributes.setMovementSpeed(0.125);
        attributes.setRunningSpeedMultiplier(3.0);
    }
}

