/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.MosquitoAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.MeganeuraEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3988;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class MosquitoAnimal
extends AbstractJSAnimal<MosquitoEntity> {
    public MosquitoAnimal() {
        super("mosquito");
        this.setAnimator(new MosquitoAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MosquitoEntity> geneticProperties) {
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MosquitoEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MosquitoEntity> miscProperties) {
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
        miscProperties.addBiomeTarget("jungle", 1, 1, 2, class_1311.field_6294, (class_6862<class_1959>)class_6908.field_36516);
        miscProperties.addBiomeTarget("swamp", 2, 2, 4, class_1311.field_6294, (class_6862<class_1959>)class_6908.field_36495);
        miscProperties.setSpawnPlacementType(class_1317.class_1319.field_19350);
        miscProperties.setSpawnHeightMap(class_2902.class_2903.field_13203);
        miscProperties.setSpawnPredicate((class_1317.class_4306<MosquitoEntity>)((class_1317.class_4306)MosquitoEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MosquitoEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, class_3988.class);
        socialGroupProperties.addScaredOf(MeganeuraEntity.class);
        socialGroupProperties.addHerdTargets(MosquitoEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(50.0f);
        socialGroupProperties.setMaxHerdSize(20);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MosquitoEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(9267005, 5643534);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MosquitoEntity> attributes, EntityBaseProperties<MosquitoEntity> base) {
        base.setAnimalType(AnimalType.INSECT);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(64.0);
        base.setTurnSmoothRate((double)0.8f);
        base.setMaxHeadRotation(90.0, 30.0);
        base.setRenderScale((double)0.15f);
        base.setLocator((ResourceLocator)new ResourceLocator<MosquitoEntity>(){
            protected Cache<String, class_2960> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

            public class_2960 getModelLocation(MosquitoEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "model:" + name;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("geo/animal/v1.0/" + name + "/" + name + ".geo.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public class_2960 getAnimationLocation(MosquitoEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "anim:" + name;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("animations/animal/v1.0/" + name + "/" + name + ".animation.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public class_2960 getTextureLocation(MosquitoEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "tex:" + name;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("textures/geo/animal/v1.0/" + name + "/" + name + ".png"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        attributes.setSpawnFar();
        attributes.setEntityFactory(MosquitoEntity::new);
        attributes.setCategory(class_1311.field_6303);
        attributes.setEyeHeight(0.5);
        attributes.setMaxHealth(0.5);
        attributes.setAttackDamage(0.0);
        attributes.setAttackSpeed(3.0);
        attributes.setDimensions(0.5, 0.5);
        attributes.setMovementSpeed((double)0.04f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.15f);
    }
}

