/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.AquaticCombatFollow;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.LeapOutOfWaterTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.TyloMoveToWaterTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersAmphibiousMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class TylosaurusEntity
extends JSAquaticBase
implements IJSLeapingEntity {
    public static final class_2940<Boolean> leaping = class_2945.method_12791(TylosaurusEntity.class, (class_2941)class_2943.field_13323);

    public TylosaurusEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.moveController = new TravelersAmphibiousMoveControl((SmartAnimalBase)this, 20, 20, 1.0f, 0.2f);
    }

    @Override
    protected TravelersPathNavigation createNavigationController(class_1937 level) {
        return new JSAmphibiousNavigation(this, level, false);
    }

    @Override
    protected void handleAirSupply(int airSupply) {
        this.method_5855(300);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)JSV1Sounds.TYLOSAURUS_LIVING.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.TYLOSAURUS_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.TYLOSAURUS_HURT.get();
    }

    @Override
    public void method_6007() {
        super.method_6007();
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(32, 16).setYVariation(8));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new TyloMoveToWaterTask(this));
        controller.registerTask((TravelerTaskBase)new AquaticCombatFollow(this));
        controller.registerTask((TravelerTaskBase)new LeapOutOfWaterTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 15;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(leaping, (Object)false);
    }

    @Override
    protected double getUpLift() {
        return 0.035;
    }

    @Override
    public void actuallyAttack(class_1309 target) {
        super.actuallyAttack(target);
        this.doSweepAttack((class_1297)this, 5.0f, 6.0f, this.method_17681());
    }

    public void doSweepAttack(class_1297 attacker, float width, float height, float depth) {
        class_243 look = attacker.method_5720().method_1029();
        class_243 center = attacker.method_19538().method_1019(look.method_1021((double)(depth / 2.0f))).method_1031(0.0, (double)(attacker.method_17682() / 2.0f), 0.0);
        class_238 hitbox = new class_238(center.field_1352 - (double)(width / 2.0f), center.field_1351 - (double)(height / 2.0f), center.field_1350 - (double)(width / 2.0f), center.field_1352 + (double)(width / 2.0f), center.field_1351 + (double)(height / 2.0f), center.field_1350 + (double)(width / 2.0f));
        List targets = attacker.method_37908().method_8390(class_1309.class, hitbox, e -> e != attacker);
        for (class_1309 target : targets) {
            if (target.method_5864() == this.method_5864()) continue;
            this.method_6121((class_1297)target);
        }
    }

    @Override
    public boolean isLeaping() {
        return (Boolean)this.field_6011.method_12789(leaping);
    }

    @Override
    public void setLeaping(boolean isLeaping) {
        this.field_6011.method_12778(leaping, (Object)isLeaping);
    }

    @Override
    public void onLeap() {
    }
}

