/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSGrazeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class BrachiosaurusEntity
extends JSAnimalBase {
    public BrachiosaurusEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected int attackAnimLength() {
        return 40;
    }

    @Override
    public float method_49476() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.BABY) {
            return class_3532.method_16439((float)this.getModules().getGrowthStageModule().getPercentage(), (float)1.0f, (float)3.0f);
        }
        return 1.0f;
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 50));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(32, 16));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this).setRange(256));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSGrazeTask(this).setMaxGrazeDuration(100));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
    }

    @Override
    public int shakeLength() {
        return 7;
    }

    @Override
    public float shakeAmount() {
        return 1.1f;
    }

    @Override
    public float shakeDistance() {
        return 90.0f;
    }

    @Override
    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.isStalking()) {
            return;
        }
        if (this.getRenderScale() > 2.0f) {
            this.method_5783((class_3414)JSSounds.GIANT_STEP.get(), 4.0f, this.method_6017());
            this.shakeCamera(this.getModules().getGrowthStageModule().getPercentage(), true);
        } else {
            super.method_5712(pos, state);
        }
    }

    protected float method_5867() {
        float speed = this.method_6029();
        return this.field_5994 + 9.0f * speed;
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)JSV1Sounds.BRACHIOSAURUS_LIVING.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.BRACHIOSAURUS_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.BRACHIOSAURUS_HURT.get();
    }
}

