/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSRangedAttack;
import jp.jurassicsaga.server.base.entity.obj.other.Spitter;
import jp.jurassicsaga.server.base.entity.obj.other.VenomSpit;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.DiloSpitTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1603;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class DilophosaurusEntity
extends JSAnimalBase
implements class_1603,
IJSRangedAttack,
Spitter {
    public boolean frillDown;
    public boolean frillUp;
    private boolean didSpit;

    public DilophosaurusEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 9));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new DiloSpitTask(this, 1.0, 40, 80, 32.0f));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    protected float method_5867() {
        float speed = this.method_6029();
        return this.field_5994 + 4.75f * speed;
    }

    @Override
    protected int attackAnimLength() {
        return 24;
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        this.getAnimationModule().playTransition(this.frillUp, JSAnimations.FRILL_OUT.wrap(10), JSAnimations.FRILL_SHAKE.wrap(), JSAnimations.FRILL_IN.wrap(10));
    }

    public double jumpHeight() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && !this.method_5799()) {
            return 2.0;
        }
        return 1.0;
    }

    @Override
    public void onSuccess() {
        this.didSpit = true;
    }

    @Override
    public boolean shouldContinue() {
        return !this.didSpit && !this.isDead();
    }

    @Override
    public void reset() {
        this.didSpit = false;
    }

    @Override
    public boolean canUse() {
        return false;
    }

    public void method_7105(class_1309 target, float velocity) {
        VenomSpit venomSpit = new VenomSpit(this.method_37908(), this);
        double d0 = target.method_23317() - this.method_23317();
        double d1 = target.method_23323(0.1) - venomSpit.method_23318();
        double d2 = target.method_23321() - this.method_23321();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        venomSpit.method_7485(d0, d1 + d3, d2, 1.5f, 2.0f);
        if (!this.method_5701() && this.getAttackSound() != null) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), this.getAttackSound(), this.method_5634(), this.method_6107(), 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        this.method_37908().method_8649((class_1297)venomSpit);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)JSV1Sounds.DILOPHOSAURUS_LIVING.get();
    }

    @Override
    @Nullable
    protected class_3414 getAttackSound() {
        return (class_3414)JSV1Sounds.DILOPHOSAURUS_ATTACK.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.DILOPHOSAURUS_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.DILOPHOSAURUS_HURT.get();
    }

    @Override
    public void spit(class_1309 livingEntity) {
        livingEntity.method_6092(new class_1293(class_1294.field_38092, 260, 5, false, false));
        livingEntity.method_6092(new class_1293(class_1294.field_5899, 20, 1, false, false));
        livingEntity.method_6092(new class_1293(class_1294.field_5901, 260, 1, false, false));
        livingEntity.method_6092(new class_1293(class_1294.field_5909, 260, 3, false, false));
        if (livingEntity instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)livingEntity;
            base.setFleeTarget((class_1297)this);
        }
    }
}

