/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.nav;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1944;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2541;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class RaptorNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private boolean canCrawl = false;
    private boolean triesToAvoidLight = false;
    private boolean canClimb;
    private boolean canClimbAnyBlock = false;
    private final class_2338.class_2339 tempPos = new class_2338.class_2339();
    private final class_2338.class_2339 tempPos2 = new class_2338.class_2339();

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = level.method_8320(below);
        if (belowState.method_26227().method_15767(class_3486.field_15517)) {
            return below.method_10264();
        }
        class_265 shape = belowState.method_26220(level, below);
        return (double)below.method_10264() + (shape.method_1110() ? 0.0 : shape.method_1105(class_2350.class_2351.field_11052));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, class_2338 pos) {
        return RaptorNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((class_1941)base.method_37908(), (class_1308)base), pos.method_25503());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, class_2338.class_2339 pos) {
        int k;
        int j;
        int i = pos.method_10263();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.method_10264(), k = pos.method_10260());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().method_31607() + 1) {
            TravelersPathType below = context.getPathTypeFromState(i, j - 1, k);
            return switch (below) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> RaptorNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        class_2338.class_2339 mp = context.mutablePos;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pt = context.getPathTypeFromState(x + i, y + j, z + k);
                    mp.method_10103(x + i, y + j, z + k);
                    if (pt == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pt == TravelersPathType.DAMAGE_FIRE || pt == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pt == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pt != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    public void markDirty(class_2338 pos) {
        this.pathTypesByPosCacheByMob.remove(pos.method_10063());
    }

    public TravelersNodeEvaluator copy() {
        RaptorNodeEvaluator nodeEvaluator = new RaptorNodeEvaluator();
        this.applyDefaultProperties(nodeEvaluator);
        nodeEvaluator.canCrawl = this.canCrawl;
        nodeEvaluator.triesToAvoidLight = this.triesToAvoidLight;
        nodeEvaluator.canClimb = this.canClimb;
        nodeEvaluator.canClimbAnyBlock = this.canClimbAnyBlock;
        return nodeEvaluator;
    }

    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.method_51504();
    }

    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @NotNull
    public TravelersNode getStart() {
        class_243 p = this.mob.method_19538();
        class_2338 start = class_2338.method_49637((double)p.field_1352, (double)p.field_1351, (double)p.field_1350);
        if (!this.isAmphibious() && this.isCanFloat()) {
            start = this.highestSubmergedNode(start);
        }
        return this.getStartNode(start);
    }

    private class_2338 highestSubmergedNode(class_2338 start) {
        class_2338.class_2339 mp;
        class_1937 level = this.mob.method_37908();
        if (!level.method_8320((class_2338)(mp = start.method_25503())).method_26227().method_15767(class_3486.field_15517)) {
            return start;
        }
        int maxY = level.method_31600() - 1;
        while (mp.method_10264() < maxY) {
            mp.method_10098(class_2350.field_11036);
            if (level.method_8320((class_2338)mp).method_26227().method_15767(class_3486.field_15517)) continue;
            mp.method_10098(class_2350.field_11033);
            break;
        }
        return mp.method_10062();
    }

    private boolean isHalfHeightCrawlGap(int x, int y, int z) {
        if (!this.canCrawl && !((JSAnimalBase)this.mob).getCrawling()) {
            return false;
        }
        class_2338 pos = new class_2338(x, y - 1, z);
        if (!this.mob.method_37908().method_8320(pos).method_26216((class_1922)this.mob.method_37908(), pos)) {
            return false;
        }
        double halfHeight = (double)this.mob.method_17682() * 0.5;
        int halfMaxY = y + class_3532.method_15384((double)halfHeight) - 1;
        for (int yi = y; yi <= halfMaxY; ++yi) {
            TravelersPathType t = this.getPathType(this.context, x, yi, z);
            if (t == TravelersPathType.OPEN || t == TravelersPathType.WALKABLE || t == TravelersPathType.WATER || t == TravelersPathType.WATER_BORDER) continue;
            return false;
        }
        int fullMaxY = y + class_3532.method_15386((float)this.mob.method_17682()) - 1;
        for (int yi = halfMaxY + 1; yi <= fullMaxY; ++yi) {
            TravelersPathType t = this.getPathType(this.context, x, yi, z);
            if (t != TravelersPathType.OPEN && t != TravelersPathType.WALKABLE) continue;
            return false;
        }
        return true;
    }

    private class_2338 findStandableStartDownOnly(class_2338 start) {
        int minY = this.mob.method_37908().method_31607();
        int startY = start.method_10264();
        int widthBlocks = class_3532.method_15386((float)this.mob.method_17681());
        int radiusMax = Math.min(8, Math.max(1, widthBlocks));
        int maxDepth = Math.max(1, class_3532.method_15375((float)(this.mob.method_17682() / 2.0f)));
        int deepestY = Math.max(startY - maxDepth, minY);
        int upwardLimit = Math.min(startY + 1, this.mob.method_37908().method_31600() - 1);
        for (int y = startY; y <= upwardLimit; ++y) {
            this.tempPos.method_10103(start.method_10263(), y, start.method_10260());
            if (!this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) continue;
            return this.tempPos.method_10062();
        }
        class_2680 stateAt = this.mob.method_37908().method_8320(start);
        if (stateAt.method_26227().method_15767(class_3486.field_15517) && !this.isAmphibious() && !this.isCanFloat()) {
            double mobHeight = this.mob.method_17682();
            double maxSubmersion = mobHeight * 0.5;
            double waterSurface = (double)start.method_10264() + 1.0;
            double mobFeet = start.method_10264();
            while (waterSurface - mobFeet > maxSubmersion) {
                class_2680 newState;
                start = start.method_10084();
                mobFeet = start.method_10264();
                if (start.method_10264() <= this.mob.method_37908().method_31600() - 2 && (newState = this.mob.method_37908().method_8320(start)).method_26227().method_15767(class_3486.field_15517)) continue;
                break;
            }
        }
        for (int y = startY; y >= deepestY; --y) {
            this.tempPos.method_10103(start.method_10263(), y, start.method_10260());
            if (this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) {
                return this.tempPos.method_10062();
            }
            for (int r = 1; r <= radiusMax; ++r) {
                int x0 = start.method_10263();
                int z0 = start.method_10260();
                for (int dx = -r; dx <= r; ++dx) {
                    this.tempPos.method_10103(x0 + dx, y, z0 - r);
                    if (this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) {
                        return this.tempPos.method_10062();
                    }
                    this.tempPos.method_10103(x0 + dx, y, z0 + r);
                    if (!this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) continue;
                    return this.tempPos.method_10062();
                }
                for (int dz = -r + 1; dz <= r - 1; ++dz) {
                    this.tempPos.method_10103(x0 - r, y, z0 + dz);
                    if (this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) {
                        return this.tempPos.method_10062();
                    }
                    this.tempPos.method_10103(x0 + r, y, z0 + dz);
                    if (!this.isSpaceValidForStanding(this.tempPos.method_10263(), this.tempPos.method_10264(), this.tempPos.method_10260())) continue;
                    return this.tempPos.method_10062();
                }
            }
        }
        return start;
    }

    protected TravelersNode getStartNode(class_2338 pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType pathtype = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return pathtype != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = 0;
        TravelersPathType above = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType at = this.getPathType(p_node.x, p_node.y, p_node.z);
        int verticalAllowance = 0;
        if (this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY) {
            verticalAllowance = class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476() + 0.1f));
        }
        this.tempPos.method_10103(p_node.x, p_node.y, p_node.z);
        double d0 = this.getFloorLevel((class_2338)this.tempPos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            TravelersNode node = this.findAcceptedNode(p_node, p_node.x + direction.method_10148(), p_node.y, p_node.z + direction.method_10165(), verticalAllowance, d0, direction, at);
            if (!this.isNeighborValid(node, p_node)) continue;
            outputArray[i++] = node;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        int steps = Math.max(Math.abs(to.x - from.x), Math.max(Math.abs(to.y - from.y), Math.abs(to.z - from.z)));
        if (steps == 0) {
            return false;
        }
        float dx = (float)(to.x - from.x) / (float)steps;
        float dy = (float)(to.y - from.y) / (float)steps;
        float dz = (float)(to.z - from.z) / (float)steps;
        for (int i = 1; i <= steps; ++i) {
            int checkZ;
            int checkY;
            int checkX = from.x + (dx > 0.0f ? (int)Math.floor(dx * (float)i) : (int)Math.ceil(dx * (float)i));
            if (this.canStandAt(checkX, checkY = from.y + (dy > 0.0f ? (int)Math.floor(dy * (float)i) : (int)Math.ceil(dy * (float)i)), checkZ = from.z + (dz > 0.0f ? (int)Math.floor(dz * (float)i) : (int)Math.ceil(dz * (float)i)))) continue;
            return true;
        }
        return false;
    }

    private boolean canStandAt(int x, int y, int z) {
        for (int dx = 0; dx < this.entityWidth; ++dx) {
            for (int dy = 0; dy < this.entityHeight; ++dy) {
                for (int dz = 0; dz < this.entityDepth; ++dz) {
                    if (!this.isBlockSolid(x + dx, y + dy, z + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isBlockSolid(int x, int y, int z) {
        this.tempPos.method_10103(x, y, z);
        return this.context.level().method_8320((class_2338)this.tempPos).method_26216((class_1922)this.context.level(), (class_2338)this.tempPos);
    }

    private boolean canReachWithoutCollision(TravelersNode node) {
        class_238 aabb = this.mob.method_5829();
        class_238 targetBox = new class_238((double)node.x, (double)node.y, (double)node.z, (double)node.x + aabb.method_17939(), (double)node.y + aabb.method_17940(), (double)node.z + aabb.method_17941());
        return !this.hasCollisions(targetBox);
    }

    protected double getFloorLevel(class_2338 pos) {
        class_1941 blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.method_24828()) && blockgetter.method_8316(pos).method_15767(class_3486.field_15517) ? (double)pos.method_10264() : RaptorNodeEvaluator.getFloorLevel((class_1922)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathTypeAtCurrent) {
        int blockLight;
        class_2338 pos;
        class_1937 level;
        int skyLight;
        int totalLight;
        int darkness;
        double mobHeight;
        double mobFeetY;
        double waterSurfaceY;
        int dy;
        TravelersNode node = null;
        boolean createdByCrawl = false;
        this.tempPos.method_10103(x, y, z);
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (diff > 0.0 ? diff > Math.floor(this.getMobJumpHeight()) : diff < 0.0 && diff > Math.floor(this.getMobJumpHeight() * 7.0)) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(pathtype);
        if (malus >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus);
        }
        if (this.isHalfHeightCrawlGap(x, y, z)) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, TravelersPathType.CRAWL, 4.0f);
            createdByCrawl = true;
        }
        if (node != null && (double)Math.abs(dy = node.y - y) > Math.floor(this.getMob().method_49476())) {
            return null;
        }
        if (diff < -1.0 && node != null) {
            int steps;
            this.tempPos2.method_10103(x, y, z);
            int i = steps = (int)(-diff);
            while ((double)i > diff) {
                this.tempPos2.method_10103(x, y + 1, z);
                class_2680 state = this.context.getBlockState((class_2338)this.tempPos2);
                if (state.method_26216((class_1922)this.context.level(), (class_2338)this.tempPos2)) {
                    return null;
                }
                --i;
            }
        }
        if (!createdByCrawl && pathtype == TravelersPathType.WATER && !this.isAmphibious() && !this.isCanFloat() && (waterSurfaceY = (double)y + 1.0) - (mobFeetY = nodeFloorLevel) > (mobHeight = (double)this.mob.method_17682()) * 0.5) {
            return null;
        }
        if (!createdByCrawl && pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathTypeAtCurrent, this.tempPos);
            } else if (!(this.isAmphibious() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.method_24828())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (RaptorNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && node.type == TravelersPathType.WALKABLE && (darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = this.mob.method_37908()).method_8314(class_1944.field_9284, pos = node.asBlockPos())) + (blockLight = level.method_8314(class_1944.field_9282, pos))))) < 2) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        boolean crawl = this.canCrawl && !((JSAnimalBase)this.mob).getCrawling() && this.isHalfHeightCrawlGap(x, y, z);
        double height = crawl ? (double)this.mob.method_17682() * 0.5 : (double)this.mob.method_17682();
        int maxY = y + class_3532.method_15384((double)height) - 1;
        for (int yi = y; yi <= maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(x, yi, z)) : !this.canClimb || !this.isClimbableAt(x, yi, z))) continue;
            return false;
        }
        return true;
    }

    private boolean isClimbableAt(int x, int y, int z) {
        this.tempPos.method_10103(x, y, z);
        class_2680 s = this.context.level().method_8320((class_2338)this.tempPos);
        if (this.canClimbAnyBlock) {
            return s.method_26220((class_1922)this.context.level(), (class_2338)this.tempPos).method_1110();
        }
        if (!this.canClimb) {
            return false;
        }
        if (s.method_26204() instanceof class_2399 || s.method_26204() instanceof class_2541) {
            return true;
        }
        if (s.method_27852(class_2246.field_16492)) {
            return true;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            this.tempPos2.method_10103(x, y, z).method_10098(dir);
            class_2680 sid = this.context.level().method_8320((class_2338)this.tempPos2);
            if (!(sid.method_26204() instanceof class_2399) && !(sid.method_26204() instanceof class_2541) && !sid.method_27852(class_2246.field_16492)) continue;
            return true;
        }
        return false;
    }

    private double getMobJumpHeight() {
        return this.canClimb ? this.mob.climbHeight() : this.mob.jumpHeight();
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathTypeAtCurrent, class_2338.class_2339 pos) {
        TravelersNode node = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathTypeAtCurrent);
        if (node == null) {
            return null;
        }
        if (node.type != TravelersPathType.OPEN && node.type != TravelersPathType.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.method_10148()) + 0.5;
        double d1 = (double)(z - direction.method_10165()) + 0.5;
        pos.method_10103(x, y + 1, z);
        double yMin = this.getFloorLevel((class_2338)pos);
        pos.method_10103((int)d0, y + (int)this.getMobJumpHeight(), (int)d1);
        double yMax = this.getFloorLevel((class_2338)pos);
        class_238 aabb = new class_238(d0 - 0.5, yMin, d1 - 0.5, d0 + 0.5, yMax, d1 + 0.5);
        if (this.hasCollisions(aabb)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        double width = this.mob.method_17681();
        boolean crawl = this.canCrawl && !((JSAnimalBase)this.mob).getCrawling() && this.isHalfHeightCrawlGap(x, y, z);
        double height = crawl ? (double)this.mob.method_17682() * 0.5 : (double)this.mob.method_17682();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15357((double)(centerX + width / 2.0));
        int maxY = class_3532.method_15357((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - width / 2.0));
        int maxZ = class_3532.method_15357((double)(centerZ + width / 2.0));
        int maxRing = (int)Math.ceil(width / 2.0);
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = y; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type;
                    int ring = Math.max(Math.abs(xi - x), Math.abs(zi - z));
                    int allowedHeight = ring = class_3532.method_15340((int)ring, (int)0, (int)maxRing);
                    if (ring > 0 && yi <= y + allowedHeight || (type = this.getPathType(this.context, xi, yi, zi)) == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        double width = Math.ceil(this.mob.method_17681());
        double height = Math.ceil(this.mob.method_17682());
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15357((double)(centerX + width / 2.0));
        int maxY = class_3532.method_15357((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - width / 2.0));
        int maxZ = class_3532.method_15357((double)(centerZ + width / 2.0));
        int cellsX = maxX - minX + 1;
        int cellsZ = maxZ - minZ + 1;
        boolean hasOuterRing = cellsX >= 3 && cellsZ >= 3;
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = y; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type;
                    boolean isOuter;
                    boolean bl = isOuter = xi == minX || xi == maxX || zi == minZ || zi == maxZ;
                    if (hasOuterRing && isOuter && yi <= y + 1 || (type = this.getPathType(this.context, xi, yi, zi)) == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.method_37908().method_31607()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            float malus = this.mob.getPathfindingMalus(pathtype);
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus);
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        int minY = this.mob.method_37908().method_31607();
        for (int i = y - 1; i >= minY; --i) {
            if (y - i > this.mob.method_5850()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(class_238 boundingBox) {
        return !this.context.level().method_8587((class_1297)this.mob, boundingBox);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)this.pathTypesByPosCacheByMob.get(key);
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathTypeOfMob(this.context, x, y, z, this.mob);
        this.pathTypesByPosCacheByMob.put(key, (Object)computed);
        return computed;
    }

    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains(TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains(TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType best = TravelersPathType.BLOCKED;
        for (TravelersPathType t : set) {
            if (mob.getPathfindingMalus(t) < 0.0f) {
                return t;
            }
            if (!(mob.getPathfindingMalus(t) >= mob.getPathfindingMalus(best))) continue;
            best = t;
        }
        return best;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType type = this.getPathType(context, x, y, z);
        boolean flag = this.isCanPassDoors();
        if (type == TravelersPathType.DOOR_WOOD_CLOSED && this.isCanOpenDoors() && flag) {
            type = TravelersPathType.WALKABLE_DOOR;
        }
        if (type == TravelersPathType.DOOR_OPEN && !flag) {
            type = TravelersPathType.BLOCKED;
        }
        enumset.add(type);
        return enumset;
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return RaptorNodeEvaluator.getPathTypeStatic(context, new class_2338.class_2339(x, y, z));
    }

    public void setCanCrawl(boolean canCrawl) {
        this.canCrawl = canCrawl;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setCanClimbAnyBlock(boolean canClimbAnyBlock) {
        this.canClimbAnyBlock = canClimbAnyBlock;
    }

    public boolean isCanClimb() {
        return this.canClimb;
    }

    public boolean isCanClimbAnyBlock() {
        return this.canClimbAnyBlock;
    }
}

