/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.IncubatorMachineMenu;
import mod.azure.azurelib.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncubatorMachineEntity
extends GenericMachineEntity {
    private final class_3913 data;
    private final Dispatcher animDispatcher;
    private final int maxProgress = 60000;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int progress5 = 0;
    private boolean closed = false;
    private int nextIdleAnim = Dispatcher.IDLE_ANIM_CD;

    public IncubatorMachineEntity(class_2338 pos, class_2680 state) {
        super(5, (class_2248)JSV1Blocks.INCUBATOR.get(), (class_2591)JSV1BlockEntities.INCUBATOR.get(), pos, state);
        this.animDispatcher = new Dispatcher(this);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 1 -> IncubatorMachineEntity.this.progress1;
                    case 2 -> IncubatorMachineEntity.this.progress2;
                    case 3 -> IncubatorMachineEntity.this.progress3;
                    case 4 -> IncubatorMachineEntity.this.progress4;
                    case 5 -> IncubatorMachineEntity.this.progress5;
                    default -> 60000;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 1: {
                        IncubatorMachineEntity.this.progress1 = value;
                        break;
                    }
                    case 2: {
                        IncubatorMachineEntity.this.progress2 = value;
                        break;
                    }
                    case 3: {
                        IncubatorMachineEntity.this.progress3 = value;
                        break;
                    }
                    case 4: {
                        IncubatorMachineEntity.this.progress4 = value;
                        break;
                    }
                    case 5: {
                        IncubatorMachineEntity.this.progress5 = value;
                    }
                }
            }

            public int method_17389() {
                return 6;
            }
        };
    }

    private void tickItem(int slot, class_1937 lvl, IncubatorMachineEntity be) {
        class_1799 slot1 = (class_1799)be.items.get(slot);
        if (lvl.field_9236) {
            return;
        }
        class_1792 class_17922 = slot1.method_7909();
        if (class_17922 instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)class_17922;
            int speed = this.field_11863.method_8450().method_8356(JSCommon.MACHINE_SPEED);
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                case 3 -> be.progress4;
                case 4 -> be.progress5;
                default -> 0;
            };
            JSGeneData geneData = JSGeneUtil.readFromStack(slot1);
            class_2960 name = class_2960.method_12838((String)geneData.getDataOwnerName(), (char)':');
            JSAnimal<?> animal1 = JSAnimals.getAnimal(name.method_12832());
            if (animal1 == null || animal1.getItems().getHatched_egg() == null) {
                return;
            }
            if ((progressCur += speed) >= be.maxProgress) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                class_1799 output = ((class_1792)animal1.getItems().getHatched_egg().get()).method_7854();
                int failChance = 0;
                int roll = this.field_11863.method_8409().method_43051(0, 100);
                if (roll < failChance) {
                    be.items.set(slot, (Object)((class_1792)JSV1Items.FAILED_EGG.get()).method_7854());
                } else {
                    if (data.isValid()) {
                        JSGeneUtil.writeToStack(output, data);
                    }
                    be.items.set(slot, (Object)output);
                }
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                    break;
                }
                case 3: {
                    be.progress4 = progressCur;
                    break;
                }
                case 4: {
                    be.progress5 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                    break;
                }
                case 3: {
                    be.progress4 = 0;
                    break;
                }
                case 4: {
                    be.progress5 = 0;
                }
            }
        }
    }

    @Nullable
    public class_1703 createMenu(int p_39954_, @NotNull class_1661 p_39955_, @NotNull class_1657 p_39956_) {
        return new IncubatorMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (!(be instanceof IncubatorMachineEntity)) {
            return;
        }
        IncubatorMachineEntity e = (IncubatorMachineEntity)be;
        this.localTick(level, e);
    }

    public void localTick(class_1937 lvl, IncubatorMachineEntity be) {
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.tickItem(3, lvl, be);
        be.tickItem(4, lvl, be);
        be.method_5431();
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("js.egg.0", this.progress1);
        tag.method_10569("js.egg.1", this.progress2);
        tag.method_10569("js.egg.2", this.progress3);
        tag.method_10569("js.egg.3", this.progress4);
        tag.method_10569("js.egg.4", this.progress5);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.progress1 = tag.method_10550("js.egg.0");
        this.progress2 = tag.method_10550("js.egg.1");
        this.progress3 = tag.method_10550("js.egg.2");
        this.progress4 = tag.method_10550("js.egg.3");
        this.progress5 = tag.method_10550("js.egg.4");
        this.closed = false;
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10569("js.egg.0", this.progress1);
        tag.method_10569("js.egg.1", this.progress2);
        tag.method_10569("js.egg.2", this.progress3);
        tag.method_10569("js.egg.3", this.progress4);
        tag.method_10569("js.egg.4", this.progress5);
        return tag;
    }

    @Override
    protected void animate(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        boolean working;
        boolean bl = working = be.getContainerData().method_17390(1) + be.getContainerData().method_17390(2) + be.getContainerData().method_17390(3) + be.getContainerData().method_17390(4) + be.getContainerData().method_17390(5) > 0;
        if (level.method_8608() || !level.method_8477(pos)) {
            return;
        }
        if (working) {
            if (!this.closed) {
                this.animDispatcher.closeLid(be);
                this.closed = true;
            }
        } else if (this.closed) {
            this.animDispatcher.openLid(be);
            this.closed = false;
        }
        if (this.nextIdleAnim > 0) {
            --this.nextIdleAnim;
        } else {
            int sec = level.method_8409().method_39332(1, 5);
            this.nextIdleAnim = (int)(JSUtils.toTickSeconds(sec) + (float)Dispatcher.IDLE_ANIM_CD);
            if (working && be.getContainerData().method_17390(0) > 0) {
                this.animDispatcher.idle_work(be);
            } else {
                this.animDispatcher.idle(be);
            }
        }
    }

    static class Dispatcher {
        public static final int IDLE_ANIM_CD = (int)JSUtils.toTickSeconds(8.0f);
        public static final AzCommand IDLE = AzCommand.create((String)"root", (String)"animation.idle", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);
        public static final AzCommand IDLE_WORK = AzCommand.create((String)"root", (String)"animation.idle_work", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand OPEN = AzCommand.create((String)"root", (String)"animation.open", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand CLOSE = AzCommand.create((String)"root", (String)"animation.close", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand HOLD_CLOSED = AzCommand.create((String)"root", (String)"animation.hold_closed", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        private final class_2586 blockEntity;

        public Dispatcher(class_2586 blockEntity) {
            this.blockEntity = blockEntity;
        }

        public void idle(class_2586 BlockEntity) {
            IDLE.sendForBlockEntity(BlockEntity);
        }

        public void idle_work(class_2586 BlockEntity) {
            IDLE_WORK.sendForBlockEntity(BlockEntity);
        }

        public void openLid(class_2586 BlockEntity) {
            OPEN.sendForBlockEntity(BlockEntity);
        }

        public void closeLid(class_2586 BlockEntity) {
            CLOSE.sendForBlockEntity(BlockEntity);
        }

        public void holdClosed(GenericMachineEntity BlockEntity) {
            HOLD_CLOSED.sendForBlockEntity((class_2586)BlockEntity);
        }
    }
}

