/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AbstractFeederEntity
extends GenericMachineEntity {
    protected final class_3913 data;
    protected int sliderPos = 50;
    protected int openTicks = 0;
    protected boolean hasToDispense;
    protected int openTime = 0;
    protected int closeTicks = 0;
    protected int checkForFeedCooldown = 200;
    protected final ArrayList<class_1297> dispensed = new ArrayList();
    protected int dispenseAmount = 0;
    protected boolean hasResult = false;

    public AbstractFeederEntity(int slots, class_2248 block, class_2591<?> pType, class_2338 pPos, class_2680 pBlockState) {
        super(slots, block, pType, pPos, pBlockState);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return AbstractFeederEntity.this.sliderPos;
            }

            public void method_17391(int index, int value) {
                AbstractFeederEntity.this.sliderPos = value;
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    @Override
    protected void animate(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof AbstractFeederEntity) {
            AbstractFeederEntity feeder = (AbstractFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    feeder.playSound(state, this.getFeederSound());
                }
                --this.openTicks;
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    feeder.playSound(state, this.getFeederSound());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)be);
            } else {
                JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((class_2586)be);
            }
        }
    }

    protected class_3414 getFeederSound() {
        return (class_3414)JSSounds.HATCH_DOOR.get();
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("sliderPos", this.sliderPos);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.setSliderPos(tag.method_10550("sliderPos"));
        this.openTicks = tag.method_10550("openTicks");
        this.openTime = tag.method_10550("openTime");
        this.hasToDispense = tag.method_10577("hasToDispense");
        this.closeTicks = tag.method_10550("closeTicks");
    }

    @Override
    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10569("sliderPos", this.sliderPos);
        tag.method_10569("openTicks", this.openTicks);
        tag.method_10569("openTime", this.openTime);
        tag.method_10556("hasToDispense", this.hasToDispense);
        tag.method_10569("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof AbstractFeederEntity) {
            class_238 checkRadius;
            List entities;
            AbstractFeederEntity feeder = (AbstractFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6; ++i) {
                    if (this.tryDispenseOne()) continue;
                    if (this.dispenseAmount <= 0) break;
                    --this.dispenseAmount;
                }
                this.dispenseAmount = 0;
                if (level.field_9236) {
                    this.addParticle(pos);
                }
            }
            if (level.field_9236) {
                return;
            }
            if (this.checkForFeedCooldown-- > 0) {
                return;
            }
            if (this.checkForNearby()) {
                class_238 nearbyDispensed = new class_238((double)(pos.method_10263() - 6), (double)(pos.method_10264() - 12), (double)(pos.method_10260() - 6), (double)(pos.method_10263() + 6), (double)(pos.method_10264() + 12), (double)(pos.method_10260() + 6));
                List balesNearby = level.method_8390(this.getClassType(), nearbyDispensed, class_1297::method_5805);
                if (balesNearby.size() > 3) {
                    return;
                }
            }
            if (!(entities = level.method_8390(JSAnimalBase.class, checkRadius = new class_238((double)(pos.method_10263() - 64), (double)(pos.method_10264() - 16), (double)(pos.method_10260() - 64), (double)(pos.method_10263() + 64), (double)(pos.method_10264() + 64), (double)(pos.method_10260() + 64)), base -> this.dietCheck(base.getModules().getMetabolismModule().getDiet()) && !base.isDead() && !base.method_6113())).isEmpty()) {
                for (JSAnimalBase entity : entities) {
                    JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                    float percentage = (float)metabolism.hungerPercentage();
                    if (!(percentage * 100.0f < (float)(feeder.getSliderPos() + 20))) continue;
                    this.dispense();
                    this.dispenseAmount = entities.size();
                    this.checkForFeedCooldown = 1600;
                    return;
                }
            }
        }
    }

    protected abstract void dispense();

    protected abstract boolean dietCheck(Diet var1);

    protected abstract <T extends class_1297> Class<T> getClassType();

    protected abstract boolean checkForNearby();

    protected void addParticle(class_2338 pos) {
        if (this.hasResult) {
            class_243 center = pos.method_46558();
            for (int i = 0; i < 50; ++i) {
                this.field_11863.method_8406((class_2394)new class_2390(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.method_10216() + this.random.nextDouble() * 2.0 - 1.0, center.method_10214() + 1.0 + this.random.nextDouble() - 1.0, center.method_10215() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
            }
        }
    }

    protected abstract boolean tryDispenseOne();

    @Override
    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.method_17391(0, sliderPos);
        this.method_5431();
    }

    public class_3913 getData() {
        return this.data;
    }

    public int getSliderPos() {
        return this.sliderPos;
    }

    public int getOpenTicks() {
        return this.openTicks;
    }

    public boolean isHasToDispense() {
        return this.hasToDispense;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public int getCloseTicks() {
        return this.closeTicks;
    }

    public int getCheckForFeedCooldown() {
        return this.checkForFeedCooldown;
    }

    public ArrayList<class_1297> getDispensed() {
        return this.dispensed;
    }

    public int getDispenseAmount() {
        return this.dispenseAmount;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public void setOpenTicks(int openTicks) {
        this.openTicks = openTicks;
    }

    public void setHasToDispense(boolean hasToDispense) {
        this.hasToDispense = hasToDispense;
    }

    public void setOpenTime(int openTime) {
        this.openTime = openTime;
    }

    public void setCloseTicks(int closeTicks) {
        this.closeTicks = closeTicks;
    }

    public void setCheckForFeedCooldown(int checkForFeedCooldown) {
        this.checkForFeedCooldown = checkForFeedCooldown;
    }

    public void setDispenseAmount(int dispenseAmount) {
        this.dispenseAmount = dispenseAmount;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }
}

