/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class LepidodendronTrunkGrower
extends class_5141 {
    public static final Codec<LepidodendronTrunkGrower> CODEC = RecordCodecBuilder.create(p_70136_ -> LepidodendronTrunkGrower.method_28904((RecordCodecBuilder.Instance)p_70136_).apply((Applicative)p_70136_, LepidodendronTrunkGrower::new));

    public LepidodendronTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return (class_5142)JSV1TrunkPlacerTypes.LEPIDODENDRON.get();
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> blockSetter, @NotNull class_5819 random, int freeTreeHeight, class_2338 pos, @NotNull class_4643 config) {
        LepidodendronTrunkGrower.method_27400((class_3746)level, blockSetter, (class_5819)random, (class_2338)pos.method_10074(), (class_4643)config);
        int height = this.field_23760 + random.method_43048(this.field_23761 + 1) + random.method_43048(this.field_23762 + 1);
        if (height < 30) {
            height = 30;
        }
        if (height > 40) {
            height = 40;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                columns.add(new Column(dx, dz, height));
            }
        }
        for (Column c : columns) {
            double dist = Math.sqrt(c.dx * c.dx + c.dz * c.dz);
            if (dist > 1.0) {
                c.maxY = random.method_43048(3);
                continue;
            }
            if (dist > 0.1) {
                c.maxY = 3 + random.method_43048(3);
                continue;
            }
            c.maxY = height;
        }
        class_2338 topPos = pos;
        for (int y = 0; y < height; ++y) {
            for (Column c : columns) {
                if (y != 0 && y > c.maxY) continue;
                class_2338 trunkPos = pos.method_10069(c.dx, y, c.dz);
                blockSetter.accept(trunkPos, config.field_21288.method_23455(random, pos));
                topPos = trunkPos;
                if (y != 0 || c.maxY > 1) continue;
                int rootLength = 1 + random.method_43048(3);
                for (int f = 1; f <= rootLength; ++f) {
                    int yOffset = 0;
                    if (f == rootLength) {
                        yOffset = (double)random.method_43057() < 0.5 ? -1 : 0;
                    } else if ((double)random.method_43057() < 0.3) {
                        yOffset = -1;
                    } else if ((double)random.method_43057() < 0.3) {
                        yOffset = 1;
                    }
                    class_2338 rootPos = pos.method_10069(c.dx * (f + 1), yOffset, c.dz * (f + 1));
                    blockSetter.accept(rootPos, config.field_21288.method_23455(random, pos));
                }
            }
        }
        int crownBaseY = (int)((double)height * 0.925);
        for (int i = 0; i < 7; ++i) {
            if (!(random.method_43057() < 0.7f)) continue;
            int dx = random.method_43056() ? 1 : -1;
            int dz = random.method_43056() ? 1 : -1;
            int supportLength = 2 + random.method_43048(2);
            int startY = crownBaseY + random.method_43048(3);
            class_2338 supportPos = pos.method_10086(startY);
            for (int s = 1; s <= supportLength; ++s) {
                class_2338 branch = supportPos.method_10069(dx * s, s / 2, dz * s);
                blockSetter.accept(branch, config.field_21288.method_23455(random, pos));
            }
        }
        this.placeCrownSupports(level, blockSetter, random, pos.method_10086(height - 2), config);
        this.placeCrown(level, blockSetter, random, topPos.method_10087(1), config);
        return ImmutableList.of((Object)new class_4647.class_5208(topPos.method_10084(), 0, false));
    }

    private void placeCrownSupports(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, class_2338 pos, class_4643 config) {
        class_2680 log = config.field_21288.method_23455(random, pos);
        int branchCount = 6 + random.method_43048(3);
        for (int i = 0; i < branchCount; ++i) {
            int dx = random.method_43056() ? 1 : -1;
            int dz = random.method_43056() ? 1 : -1;
            int length = 2 + random.method_43048(2);
            int baseY = random.method_43048(3);
            class_2338 branchBase = pos.method_10086(baseY);
            for (int s = 1; s <= length; ++s) {
                class_2338 branch = branchBase.method_10069(dx * s, s / 3, dz * s);
                blockSetter.accept(branch, log);
                if (s != length) continue;
                class_2680 leaves = config.field_29280.method_23455(random, branch);
                this.placeLeafLayer(level, blockSetter, branch, leaves, 2);
            }
        }
    }

    private void placeCrown(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, class_2338 pos, class_4643 config) {
        class_2680 leaves = config.field_29280.method_23455(random, pos);
        this.placeLeafLayer(level, blockSetter, pos.method_10074(), leaves, 3);
        this.placeLeafLayer(level, blockSetter, pos, leaves, 4);
        this.placeLeafLayer(level, blockSetter, pos.method_10084(), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.method_10086(2), leaves, 6);
        this.placeLeafLayer(level, blockSetter, pos.method_10086(3), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.method_10086(4), leaves, 4);
        this.placeLeafLayer(level, blockSetter, pos.method_10086(5), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.method_10086(6), leaves, 3);
    }

    private void placeLeafLayer(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_2338 pos, class_2680 leaves, int radius) {
        int rSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > rSq) continue;
                class_2338 leafPos = pos.method_10069(dx, 0, dz);
                this.tryPlaceLeaf(level, blockSetter, leafPos, leaves);
            }
        }
    }

    private void tryPlaceLeaf(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_2338 pos, class_2680 state) {
        if (this.isValid(level, pos)) {
            blockSetter.accept(pos, state);
        }
    }

    public boolean isValid(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, class_4970.class_4971::method_26215);
    }

    private static class Column {
        final int dx;
        final int dz;
        int maxY;

        Column(int dx, int dz, int maxY) {
            this.dx = dx;
            this.dz = dz;
            this.maxY = maxY;
        }
    }
}

