/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.ProcompsognathusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3988;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalType;

public class CompsognathusAnimal
extends AbstractJSAnimal<CompsognathusEntity> {
    public CompsognathusAnimal() {
        super("compsognathus");
        this.setAnimator(new ProcompsognathusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<CompsognathusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.075f);
        geneticProperties.addGrowthStageSize(0.2f, 0.36f);
        geneticProperties.addGrowthNextStageScaling(0.19f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(3.0f));
        geneticProperties.addSupportedGenes(JSGenetics.ALPINE_COSMETIC, JSGenetics.OCEAN_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<CompsognathusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(0.9f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<CompsognathusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setGuidebookScaling(new float[]{2.0f, 3.6f});
        miscProperties.setGuidebookOffset(new class_241(0.5f, 0.0f), new class_241(-0.25f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Compsognathus is a genus of small, bipedal, carnivorous theropod dinosaur. Members of its single species Compsognathus longipes could grow to around the size of a chicken.");
        miscProperties.setGuideBookSource("Europe");
        miscProperties.setGuideBookScientificName("Compsognathus longipes");
        miscProperties.setAdvancementTitle("Dieter's Demise");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<CompsognathusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, class_1429.class, class_1588.class, class_3988.class, DryosaurusEntity.class, BasiliskEntity.class, GoatEntity.class, OstrichEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, MicroceratusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class);
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.addHerdTargets(CompsognathusEntity.class, ProcompsognathusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(150.0f);
        socialGroupProperties.setMaxHerdSize(10);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<CompsognathusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.BASILISK);
        itemProperties.setSpawnEggColors(13482096, 8488000);
        itemProperties.setSpawnEggColorsMale(13599561, 7500863);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<CompsognathusEntity> attributes, EntityBaseProperties<CompsognathusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setMaxTurnRate(9.0);
        base.setTurnSmoothRate(0.85);
        base.setRenderScale((double)0.19f);
        base.setLocator((ResourceLocator)new JSAnimalBaseLocator<CompsognathusEntity>(){

            @Override
            public class_2960 getModelLocation(CompsognathusEntity entity) {
                String key = this.makeCacheKey(entity, "model");
                try {
                    return (class_2960)this.cache.get((Object)key, () -> {
                        String entity_name = this.getEntityName(entity);
                        String version = this.getVersion(entity);
                        return JSCommon.createId("geo/animal/" + version + "/" + entity_name + "/" + entity_name + ".geo.json");
                    });
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        attributes.setPersistent();
        attributes.setEntityFactory(CompsognathusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(9.0);
        attributes.setDimensions(0.25, (double)0.55f);
        attributes.setTrackingRange(32.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(13.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.6f);
        attributes.setAttackDamage(1.0);
        attributes.setAttackSpeed(2.0);
        attributes.setAttackKnockback(0.5);
        attributes.setFollowRange(64.0);
    }
}

