/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.entity.obj;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.v2.block.entity.JSV2BlockEntities;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class WireBlockEntity
extends class_2586 {
    @Nullable
    private class_2338 connectionA = null;
    @Nullable
    private class_2338 connectionB = null;
    private class_243 preferredDir = new class_243(1.0, 0.0, 0.0);
    private class_265 cachedShape = class_259.method_1077();

    public WireBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)JSV2BlockEntities.WIRE.get(), pos, state);
    }

    public void updateConnections() {
        class_243 dir;
        double dist;
        class_243 delta;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.connectionA = null;
        this.connectionB = null;
        class_243 myCenter = class_243.method_24953((class_2382)this.field_11867);
        double radius = 2.5;
        ArrayList<class_2338> candidates = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)this.field_11867.method_10069(-2, -2, -2), (class_2338)this.field_11867.method_10069(2, 2, 2))) {
            class_2586 be;
            if (pos.equals((Object)this.field_11867) || !((be = this.field_11863.method_8321(pos)) instanceof WireBlockEntity)) continue;
            candidates.add(pos.method_10062());
        }
        if (candidates.isEmpty()) {
            this.rebuildShapeCache();
            return;
        }
        class_243 bestDirA = null;
        class_243 bestDirB = null;
        double bestDistA = Double.MAX_VALUE;
        double bestDistB = Double.MAX_VALUE;
        for (class_2338 pos : candidates) {
            delta = class_243.method_24953((class_2382)pos).method_1020(myCenter);
            dist = delta.method_1033();
            if (dist > radius) continue;
            dir = delta.method_1029();
            if (Math.abs(dir.field_1351) > 0.7 || !(dist < bestDistA)) continue;
            bestDistA = dist;
            bestDirA = dir;
            this.connectionA = pos;
        }
        if (bestDirA != null) {
            this.preferredDir = bestDirA;
        }
        for (class_2338 pos : candidates) {
            double dot;
            if (pos.equals((Object)this.connectionA) || (dist = (delta = class_243.method_24953((class_2382)pos).method_1020(myCenter)).method_1033()) > radius || !((dot = this.preferredDir.method_1026(dir = delta.method_1029())) < -0.6) || !(dist < bestDistB)) continue;
            bestDistB = dist;
            bestDirB = dir;
            this.connectionB = pos;
        }
        this.rebuildShapeCache();
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public void rebuildShapeCache() {
        class_265 shape = class_259.method_1081((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        class_243 center = class_243.method_24953((class_2382)this.field_11867);
        if (this.connectionA != null) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1078((class_238)this.createWireAABB(center, class_243.method_24953((class_2382)this.connectionA), 0.1)));
        }
        if (this.connectionB != null) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1078((class_238)this.createWireAABB(center, class_243.method_24953((class_2382)this.connectionB), 0.1)));
        }
        this.cachedShape = shape.method_1097();
    }

    private class_238 createWireAABB(class_243 from, class_243 to, double radius) {
        double minX = Math.min(from.field_1352, to.field_1352) - radius;
        double minY = Math.min(from.field_1351, to.field_1351) - radius;
        double minZ = Math.min(from.field_1350, to.field_1350) - radius;
        double maxX = Math.max(from.field_1352, to.field_1352) + radius;
        double maxY = Math.max(from.field_1351, to.field_1351) + radius;
        double maxZ = Math.max(from.field_1350, to.field_1350) + radius;
        return new class_238(minX - from.field_1352 + 0.5, minY - from.field_1351 + 0.5, minZ - from.field_1350 + 0.5, maxX - from.field_1352 + 0.5, maxY - from.field_1351 + 0.5, maxZ - from.field_1350 + 0.5);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.connectionA != null) {
            tag.method_10544("connA", this.connectionA.method_10063());
        }
        if (this.connectionB != null) {
            tag.method_10544("connB", this.connectionB.method_10063());
        }
        tag.method_10566("dir", (class_2520)WireBlockEntity.saveVec(this.preferredDir));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.connectionA = tag.method_10545("connA") ? class_2338.method_10092((long)tag.method_10537("connA")) : null;
        this.connectionB = tag.method_10545("connB") ? class_2338.method_10092((long)tag.method_10537("connB")) : null;
        this.preferredDir = WireBlockEntity.loadVec(tag.method_10562("dir"));
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.rebuildShapeCache();
        }
    }

    private static class_2487 saveVec(class_243 v) {
        class_2487 t = new class_2487();
        t.method_10549("x", v.field_1352);
        t.method_10549("y", v.field_1351);
        t.method_10549("z", v.field_1350);
        return t;
    }

    private static class_243 loadVec(class_2487 t) {
        return new class_243(t.method_10574("x"), t.method_10574("y"), t.method_10574("z"));
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public List<class_243> getConnectionCenters() {
        ArrayList<class_243> list = new ArrayList<class_243>();
        if (this.connectionA != null) {
            list.add(class_243.method_24953((class_2382)this.connectionA));
        }
        if (this.connectionB != null) {
            list.add(class_243.method_24953((class_2382)this.connectionB));
        }
        return list;
    }

    @Nullable
    public class_2338 getConnectionA() {
        return this.connectionA;
    }

    @Nullable
    public class_2338 getConnectionB() {
        return this.connectionB;
    }

    public class_243 getPreferredDir() {
        return this.preferredDir;
    }

    public class_265 getCachedShape() {
        return this.cachedShape;
    }
}

