/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import com.google.common.base.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.server.MinecraftServer;
import travelers.FabricTravelers;
import travelers.GeckoLibDisabler;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.world.TravelersBiomeModificator;
import travelers.util.helper.obj.IGenericProperties;
import travelers.world.FabricTravelersBiomeModificator;

public class FabricGenericProperties
implements IGenericProperties {
    private static final FabricTravelersBiomeModificator biomeModificator = new FabricTravelersBiomeModificator();

    @Override
    public String getPlatformName() {
        return "fabric";
    }

    @Override
    public MinecraftServer getServer() {
        return FabricTravelers.getServer();
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayersTrackingEntity(class_1297 mob, T payload) {
        if (mob.method_37908() instanceof class_3218) {
            class_2540 buf = PacketByteBufs.create();
            payload.encode(buf);
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_1297)mob)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)payload.id(), (class_2540)buf);
            }
        }
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayersTrackingBlockEntity(class_2586 blockEntity, T payload) {
        if (blockEntity.method_10997() instanceof class_3218) {
            class_2540 buf = PacketByteBufs.create();
            payload.encode(buf);
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_2586)blockEntity)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)payload.id(), (class_2540)buf);
            }
        }
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToServer(T payload) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_2540 buf = PacketByteBufs.create();
            payload.encode(buf);
            ClientPlayNetworking.send((class_2960)payload.id(), (class_2540)buf);
        }
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayer(class_3222 player, T payload) {
        class_2540 buf = PacketByteBufs.create();
        payload.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)payload.id(), (class_2540)buf);
    }

    @Override
    public <T> T register(class_2378<T> registry, class_2960 id, Supplier<T> supplier) {
        if (registry.method_10250(id)) {
            return (T)registry.method_10223(id);
        }
        return (T)class_2378.method_10230(registry, (class_2960)id, (Object)supplier.get());
    }

    @Override
    public void disableGecko(String modId) {
        GeckoLibDisabler.disableGecko(modId);
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public <T extends SmartAnimalBase> void registerAnimal(TravelersAnimal<T> animal) {
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)animal.getEntityType().get()), (class_5132.class_5133)animal.createAnimalAttributes());
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public TravelersBiomeModificator getBiomeModificator() {
        return biomeModificator;
    }
}

