/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class TravelersClientAnimator {
    protected final Map<String, TravelersAnimationData> boneOffsetCache = new Object2ObjectOpenHashMap();
    private final Map<String, TravelersBoneState> frameBoneCache = new Object2ObjectOpenHashMap();

    public final void update(SmartAnimalBase animatable, float partialTick) {
        TravelersAnimationData animData = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        this.updateModel(animatable, partialTick, animData);
    }

    public void beginFrame() {
        this.frameBoneCache.clear();
    }

    public TravelersBoneState getCachedBoneState(String boneName) {
        return this.frameBoneCache.get(boneName);
    }

    public void cacheBoneState(String boneName, TravelersBoneState state) {
        if (state != null) {
            this.frameBoneCache.put(boneName, state);
        }
    }

    protected TravelersAnimationData createData() {
        return new TravelersAnimationData();
    }

    protected List<TravelersBoneState> getBones(TravelersAnimationData animData, String ... bones) {
        ArrayList<TravelersBoneState> result = new ArrayList<TravelersBoneState>();
        for (String bone : bones) {
            result.add(this.bone(animData, bone));
        }
        return result;
    }

    protected TravelersBoneState bone(TravelersAnimationData animData, String name) {
        return animData.boneMap.computeIfAbsent(name, string -> new TravelersBoneState());
    }

    public abstract void updateModel(SmartAnimalBase var1, float var2, TravelersAnimationData var3);

    public int maxYawAngle() {
        return 45;
    }

    public int maxPitchAngle() {
        return 45;
    }

    public void faceTarget(SmartAnimalBase e, float pt, float rotationDivisor, List<TravelersBoneState> bones) {
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(e.method_5845(), id -> this.createData());
        float totalYaw = 0.0f;
        float totalPitch = 0.0f;
        if (data.canFace) {
            float bodyYaw = class_3532.method_16439((float)pt, (float)e.field_6220, (float)e.field_6283);
            float headYaw = class_3532.method_16439((float)pt, (float)e.field_6259, (float)e.method_5791());
            float pitchDeg = class_3532.method_16439((float)pt, (float)e.field_6004, (float)e.method_36455());
            float yawDeltaDeg = class_3532.method_15393((float)(headYaw - bodyYaw));
            totalYaw = -(yawDeltaDeg * ((float)Math.PI / 180)) / Math.max(1.0E-6f, rotationDivisor);
            totalPitch = -(pitchDeg * ((float)Math.PI / 180)) / Math.max(1.0E-6f, rotationDivisor);
        }
        float maxYaw = (float)this.maxYawAngle() * ((float)Math.PI / 180);
        float maxPitch = (float)this.maxPitchAngle() * ((float)Math.PI / 180);
        float fps = Math.max(1, class_310.method_1551().method_47599());
        float t = Math.min(1.0f, this.headRotSpeed() / fps);
        int n = Math.max(1, bones.size());
        for (int i = 0; i < n; ++i) {
            TravelersBoneState b = bones.get(i);
            float w = ((float)i + 1.0f) / (float)n;
            float targetY = totalYaw * w;
            float targetX = totalPitch * w;
            b.angleYo = b.angleY;
            b.angleY = class_3532.method_16439((float)t, (float)b.angleY, (float)(data.canFace ? targetY : 0.0f));
            b.angleXo = b.angleX;
            b.angleX = class_3532.method_16439((float)t, (float)b.angleX, (float)(data.canFace ? targetX : 0.0f));
            b.angleY = class_3532.method_15363((float)b.angleY, (float)(-maxYaw), (float)maxYaw);
            b.angleX = class_3532.method_15363((float)b.angleX, (float)(-maxPitch), (float)maxPitch);
        }
    }

    protected float headRotSpeed() {
        return 2.4f;
    }

    public void chainWave(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float waveAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, waveAmount, offset, i);
            state.angleXo = state.angleX;
            state.angleX = rotation;
        }
    }

    public void chainSwing(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, swingAmount, offset, i);
            state.angleYo = state.angleY;
            state.angleY = rotation;
        }
    }

    public void chainFlap(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float flapAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            state.angleZ = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, flapAmount, offset, i);
        }
    }

    private float calculateChainRotation(float animationSpeed, float maxDegree, float animationProgress, float amplitude, float phaseOffset, int segmentIndex) {
        float phase = animationProgress * animationSpeed + phaseOffset * (float)segmentIndex;
        return class_3532.method_15362((float)phase) * amplitude * maxDegree;
    }

    private float calculateChainOffset(double rootOffset, List<String> boneNames) {
        return (float)(rootOffset * Math.PI / (double)(2 * boneNames.size()));
    }

    public void remove(SmartAnimalBase entity) {
        this.boneOffsetCache.remove(entity.method_5845());
    }

    public TravelersBoneState updateAnimationOnBone(SmartAnimalBase base, String bone) {
        TravelersAnimationData data = this.boneOffsetCache.get(base.method_5845());
        return data != null ? data.boneMap.get(bone) : null;
    }

    public void clientTick(SmartAnimalBase base) {
        this.getData(base).tick(base);
    }

    protected TravelersAnimationData getData(SmartAnimalBase base) {
        return this.boneOffsetCache.computeIfAbsent(base.method_5845(), string -> this.createData());
    }
}

