/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.other;

import net.minecraft.class_1308;
import net.minecraft.class_1330;
import net.minecraft.class_3532;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersBodyRotationControl
extends class_1330 {
    private final SmartAnimalBase mob;
    private int headStableTime;
    private float rotationSpeed = -1.0f;

    public TravelersBodyRotationControl(SmartAnimalBase mob) {
        super((class_1308)mob);
        this.mob = mob;
    }

    public void method_6224() {
        if (this.mob.method_6113()) {
            return;
        }
        if (this.isMoving()) {
            this.mob.field_6283 = this.lerpRotation(this.mob.field_6283, this.mob.method_36454(), this.getTurnSpeed());
            this.rotateHeadIfNecessary();
            this.headStableTime = 0;
        } else {
            ++this.headStableTime;
            if (this.headStableTime > 10) {
                this.rotateHeadTowardsFrontSmooth();
            }
        }
    }

    protected float getTurnSpeed() {
        if (this.mob.getAnimal() == null) {
            return 1.0f;
        }
        float TURN = (float)this.mob.getAnimal().getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
        double progressPercentage = this.mob.method_17825();
        if (progressPercentage < 1.0) {
            TURN *= (float)class_3532.method_16436((double)progressPercentage, (double)2.0, (double)1.0);
        }
        this.rotationSpeed = TURN / 10.0f;
        return this.rotationSpeed;
    }

    private void rotateHeadIfNecessary() {
        float targetAngle = this.mob.field_6283;
        float maxRotation = this.mob.method_5986();
        this.mob.field_6241 = this.smoothRotate(this.mob.field_6241, targetAngle, maxRotation, this.getTurnSpeed());
    }

    private void rotateHeadTowardsFrontSmooth() {
        int i = this.headStableTime - 10;
        float progress = class_3532.method_15363((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
        float maxRotation = (float)this.mob.method_5986() * (1.0f - progress);
        this.mob.field_6283 = this.smoothRotate(this.mob.field_6283, this.mob.field_6241, maxRotation, this.getTurnSpeed());
    }

    private boolean isMoving() {
        double dz;
        double dx = this.mob.method_23317() - this.mob.field_6014;
        return dx * dx + (dz = this.mob.method_23321() - this.mob.field_5969) * dz > (double)2.5E-7f;
    }

    private float lerpRotation(float current, float target, float speed) {
        float diff = this.wrapDegrees(target - current);
        return current + diff * speed;
    }

    private float smoothRotate(float current, float target, float maxRotation, float speed) {
        float diff = this.wrapDegrees(target - current);
        diff = class_3532.method_15363((float)diff, (float)(-maxRotation), (float)maxRotation);
        return this.lerpRotation(current, current + diff, speed);
    }

    private float wrapDegrees(float degrees) {
        if ((degrees %= 360.0f) >= 180.0f) {
            degrees -= 360.0f;
        }
        if (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }
}

