/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_5996;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersConstants;
import travelers.TravelersMain;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPath {
    private final List<TravelersNode> nodes;
    private final class_2338 target;
    private final float distToTarget;
    private final boolean reached;
    @Nullable
    private DebugData debugData;
    private int nextNodeIndex;

    public TravelersPath(List<TravelersNode> nodes, class_2338 target, boolean reached) {
        this.nodes = nodes;
        this.target = target;
        this.distToTarget = nodes.isEmpty() ? Float.MAX_VALUE : this.nodes.get(nodes.size() - 1).distanceManhattan(this.target);
        this.reached = reached;
        this.setDebug(new TravelersNode[0], new TravelersNode[0], Set.of(new TravelersTarget(target.method_10263(), target.method_10264(), target.method_10260())));
        this.nextNodeIndex = 0;
    }

    public static TravelersPath createFromStream(class_2540 buf) {
        boolean reached = buf.readBoolean();
        int idx = buf.readInt();
        class_2338 target = buf.method_10811();
        List list = buf.method_34066(TravelersNode::createFromStream);
        DebugData debug = DebugData.read(buf);
        TravelersPath path = new TravelersPath(list, target, reached);
        path.debugData = debug;
        path.nextNodeIndex = idx;
        return path;
    }

    public static void writeNodeArray(class_2540 buffer, TravelersNode[] array) {
        buffer.writeInt(array.length);
        for (TravelersNode node : array) {
            node.writeToStream(buffer);
        }
    }

    public static TravelersNode[] readNodeArray(class_2540 buffer) {
        int length = buffer.readInt();
        TravelersNode[] array = new TravelersNode[length];
        for (int i = 0; i < length; ++i) {
            array[i] = TravelersNode.createFromStream(buffer);
        }
        return array;
    }

    public void advance() {
        if (this.nextNodeIndex < this.nodes.size()) {
            ++this.nextNodeIndex;
        }
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public TravelersNode getEndNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1);
    }

    public TravelersNode getNode(int index) {
        return this.nodes.get(index);
    }

    public void replaceNode(int index, TravelersNode point) {
        this.nodes.set(index, point);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public class_243 getEntityPosAtNode(class_1297 entity, int index) {
        if (index < 0 || index >= this.nodes.size()) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("getEntityPosAtNode - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            }
            return class_243.field_1353;
        }
        TravelersNode node = this.nodes.get(index);
        return class_243.method_24955((class_2382)node.asBlockPos());
    }

    public class_2338 getNodePos(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("getNodePos - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            }
            return class_2338.field_10980;
        }
        return this.nodes.get(index).asBlockPos();
    }

    public class_243 getNextEntityPos(class_1297 entity) {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? class_243.field_1353 : class_243.method_24955((class_2382)this.nodes.get(this.nodes.size() - 1).asBlockPos());
        }
        return this.getEntityPosAtNode(entity, this.nextNodeIndex);
    }

    public class_2338 getNextNodePos() {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? class_2338.field_10980 : this.nodes.get(this.nodes.size() - 1).asBlockPos();
        }
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public TravelersNode getNextNode() {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1);
        }
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public TravelersNode getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable TravelersPath other) {
        if (other == null || other.nodes.size() != this.nodes.size()) {
            return false;
        }
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            TravelersNode a = this.nodes.get(i);
            TravelersNode b = other.nodes.get(i);
            if (a.x == b.x && a.y == b.y && a.z == b.z) continue;
            return false;
        }
        return true;
    }

    public boolean canReach() {
        return this.reached;
    }

    @class_5996
    void setDebug(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        this.debugData = new DebugData(openSet, closedSet, targetNodes);
    }

    @Nullable
    public DebugData debugData() {
        return this.debugData;
    }

    public void writeToStream(class_2540 buffer) {
        if (this.debugData == null || this.debugData.targetNodes.isEmpty()) {
            return;
        }
        buffer.writeBoolean(this.reached);
        buffer.writeInt(this.nextNodeIndex);
        buffer.method_10807(this.target);
        buffer.method_34062(this.nodes, (buf, node) -> node.writeToStream((class_2540)buf));
        this.debugData.write(buffer);
    }

    public String toString() {
        return "TravelersPath[length=" + this.nodes.size() + ", index=" + this.nextNodeIndex + "]";
    }

    public TravelersPath copy() {
        ArrayList<TravelersNode> copiedNodes = new ArrayList<TravelersNode>(this.nodes);
        TravelersPath path = new TravelersPath(copiedNodes, this.target, this.reached);
        path.debugData = this.debugData;
        path.nextNodeIndex = this.nextNodeIndex;
        return path;
    }

    public List<TravelersNode> getNodes() {
        return this.nodes;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }

    public boolean isReached() {
        return this.reached;
    }

    @Nullable
    public DebugData getDebugData() {
        return this.debugData;
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setDebugData(@Nullable DebugData debugData) {
        this.debugData = debugData;
    }

    public void setNextNodeIndex(int nextNodeIndex) {
        this.nextNodeIndex = nextNodeIndex;
    }

    public record DebugData(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        public static DebugData read(class_2540 buffer) {
            HashSet targets = (HashSet)buffer.method_34068(HashSet::new, TravelersTarget::createFromStream);
            TravelersNode[] open = TravelersPath.readNodeArray(buffer);
            TravelersNode[] closed = TravelersPath.readNodeArray(buffer);
            return new DebugData(open, closed, targets);
        }

        public void write(class_2540 buffer) {
            buffer.method_34062(this.targetNodes, (buf, target) -> target.writeToStream((class_2540)buf));
            TravelersPath.writeNodeArray(buffer, this.openSet);
            TravelersPath.writeNodeArray(buffer, this.closedSet);
        }
    }
}

