/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class TravelersNode {
    public int x;
    public int y;
    public int z;
    public int hash;
    int heapIdx = -1;
    public float g;
    public float h;
    public float f;
    public float walkedDistance;
    public float costMalus;
    public boolean closed;
    public TravelersPathType type = TravelersPathType.BLOCKED;
    @Nullable
    public TravelersNode cameFrom;
    private class_2338 cachedPos;
    private class_243 cachedVec;

    public TravelersNode(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hash = TravelersNode.createHash(x, y, z);
    }

    public TravelersNode() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.hash = 0;
    }

    public static int createHash(int x, int y, int z) {
        return y & 0xFF | (x & Short.MAX_VALUE) << 8 | (z & Short.MAX_VALUE) << 24 | (x < 0 ? Integer.MIN_VALUE : 0) | (z < 0 ? 32768 : 0);
    }

    public static TravelersNode createFromStream(class_2540 buffer) {
        TravelersNode node = new TravelersNode(buffer.readInt(), buffer.readInt(), buffer.readInt());
        TravelersNode.readContents(buffer, node);
        return node;
    }

    protected static void readContents(class_2540 buffer, TravelersNode node) {
        node.walkedDistance = buffer.readFloat();
        node.costMalus = buffer.readFloat();
        node.closed = buffer.readBoolean();
        node.type = (TravelersPathType)buffer.method_10818(TravelersPathType.class);
        node.f = buffer.readFloat();
    }

    public TravelersNode cloneAndMove(int x, int y, int z) {
        TravelersNode node = new TravelersNode(x, y, z);
        node.g = this.g;
        node.h = this.h;
        node.f = this.f;
        node.cameFrom = this.cameFrom;
        node.closed = this.closed;
        node.walkedDistance = this.walkedDistance;
        node.costMalus = this.costMalus;
        node.type = this.type;
        return node;
    }

    public float distanceTo(TravelersNode other) {
        float dx = other.x - this.x;
        float dy = other.y - this.y;
        float dz = other.z - this.z;
        return class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
    }

    public float distanceToXZ(TravelersNode other) {
        float dx = other.x - this.x;
        float dz = other.z - this.z;
        return class_3532.method_15355((float)(dx * dx + dz * dz));
    }

    public float distanceTo(class_2338 pos) {
        float dx = pos.method_10263() - this.x;
        float dy = pos.method_10264() - this.y;
        float dz = pos.method_10260() - this.z;
        return class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
    }

    public float distanceToSqr(TravelersNode other) {
        float dx = other.x - this.x;
        float dy = other.y - this.y;
        float dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToSqr(class_2338 pos) {
        float dx = pos.method_10263() - this.x;
        float dy = pos.method_10264() - this.y;
        float dz = pos.method_10260() - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceManhattan(TravelersNode other) {
        return Math.abs(other.x - this.x) + Math.abs(other.y - this.y) + Math.abs(other.z - this.z);
    }

    public float distanceManhattan(class_2338 pos) {
        return Math.abs(pos.method_10263() - this.x) + Math.abs(pos.method_10264() - this.y) + Math.abs(pos.method_10260() - this.z);
    }

    public class_2338 asBlockPos() {
        if (this.cachedPos == null) {
            this.cachedPos = new class_2338(this.x, this.y, this.z);
        }
        return this.cachedPos;
    }

    public class_243 asVec3() {
        if (this.cachedVec == null) {
            this.cachedVec = new class_243((double)this.x, (double)this.y, (double)this.z);
        }
        return this.cachedVec;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TravelersNode)) {
            return false;
        }
        TravelersNode other = (TravelersNode)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.hash == other.hash;
    }

    public void reset() {
        this.heapIdx = -1;
        this.f = 0.0f;
        this.h = 0.0f;
        this.g = 0.0f;
        this.walkedDistance = 0.0f;
        this.costMalus = 0.0f;
        this.closed = false;
        this.type = TravelersPathType.BLOCKED;
        this.cameFrom = null;
        this.cachedPos = null;
        this.cachedVec = null;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "JSNode{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public void writeToStream(class_2540 buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeFloat(this.walkedDistance);
        buffer.writeFloat(this.costMalus);
        buffer.writeBoolean(this.closed);
        buffer.method_10817((Enum)this.type);
        buffer.writeFloat(this.f);
    }
}

