/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.class_10;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathTypeCache;

public class TravelersPathfindingContext {
    public final class_2338.class_2339 mutablePos = new class_2338.class_2339();
    private final class_1941 level;
    @Nullable
    private final TravelersPathTypeCache cache;
    private final class_2338 mobPosition;

    public TravelersPathfindingContext(class_1941 level, class_1308 mob) {
        TravelersPathTypeCache travelersPathTypeCache;
        this.level = level;
        class_1937 class_19372 = mob.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            travelersPathTypeCache = TravelersMain.getCache((class_1937)serverLevel);
        } else {
            travelersPathTypeCache = null;
        }
        this.cache = travelersPathTypeCache;
        this.mobPosition = mob.method_24515();
    }

    protected static TravelersPathType getPathTypeFromState(class_1922 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (state.method_26215()) {
            return TravelersPathType.OPEN;
        }
        if (state.method_26164(class_3481.field_15487) || state.method_27852(class_2246.field_10588) || state.method_27852(class_2246.field_28682)) {
            return TravelersPathType.TRAPDOOR;
        }
        if (state.method_27852(class_2246.field_27879)) {
            return TravelersPathType.POWDER_SNOW;
        }
        if (state.method_27852(class_2246.field_10029) || state.method_27852(class_2246.field_16999)) {
            return TravelersPathType.DAMAGE_OTHER;
        }
        if (state.method_27852(class_2246.field_21211)) {
            return TravelersPathType.STICKY_HONEY;
        }
        if (state.method_27852(class_2246.field_10302)) {
            return TravelersPathType.COCOA;
        }
        if (state.method_27852(class_2246.field_10606) || state.method_27852(class_2246.field_28048)) {
            return TravelersPathType.DAMAGE_CAUTIOUS;
        }
        class_3610 fluid = state.method_26227();
        if (fluid.method_15767(class_3486.field_15518)) {
            return TravelersPathType.LAVA;
        }
        if (TravelersNodeEvaluator.isBurningBlock(state)) {
            return TravelersPathType.DAMAGE_FIRE;
        }
        if (block instanceof class_2323) {
            class_2323 door = (class_2323)block;
            return (Boolean)state.method_11654((class_2769)class_2323.field_10945) != false ? TravelersPathType.DOOR_OPEN : (door.method_51169().comp_1471() ? TravelersPathType.DOOR_WOOD_CLOSED : TravelersPathType.DOOR_IRON_CLOSED);
        }
        if (block instanceof class_2241) {
            class_2241 rail = (class_2241)block;
            return TravelersPathType.RAIL;
        }
        if (block instanceof class_2397) {
            class_2397 rail = (class_2397)block;
            return TravelersPathType.LEAVES;
        }
        if (state.method_26164(class_3481.field_16584) || state.method_26164(class_3481.field_15504) || block instanceof class_2349 && !((Boolean)state.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
            return TravelersPathType.FENCE;
        }
        if (!state.method_26171(level, pos, class_10.field_50)) {
            return TravelersPathType.BLOCKED;
        }
        return fluid.method_15767(class_3486.field_15517) ? TravelersPathType.WATER : TravelersPathType.OPEN;
    }

    public TravelersPathType getPathTypeFromState(int x, int y, int z) {
        class_2338.class_2339 pos = this.mutablePos.method_10103(x, y, z);
        return TravelersPathfindingContext.getPathTypeFromState((class_1922)this.level, (class_2338)pos);
    }

    public class_2680 getBlockState(class_2338 pos) {
        return this.level.method_8320(pos);
    }

    public class_1941 level() {
        return this.level;
    }

    public class_2338 mobPosition() {
        return this.mobPosition;
    }

    class_2338 currentEvalPos() {
        return this.mutablePos;
    }
}

