/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj.animation;

import java.util.HashMap;
import java.util.function.Supplier;
import travelers.TravelersConstants;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.PlayBehaviourType;
import travelers.server.animal.obj.animation.TravelersAnimationDefinition;
import travelers.server.animal.obj.animation.TravelersAnimationWrapper;

public class TravelersAnimationManager {
    private final HashMap<String, Integer> timers = new HashMap();
    private final HashMap<String, Boolean> conditions = new HashMap();
    private final SmartAnimalBase entity;

    public TravelersAnimationManager(SmartAnimalBase entity) {
        this.entity = entity;
    }

    public void initialize() {
    }

    public void tick() {
    }

    public boolean play(TravelersAnimationWrapper animation) {
        int in;
        if (animation.getTickDuration() == 0) {
            this.play(animation.getAnimation());
            return true;
        }
        if (!this.containsTimer(animation.getAnimation().getName())) {
            this.setTimer(animation.getAnimation().getName(), animation.getTickDuration());
        }
        if ((in = this.getTimer(animation.getAnimation().getName())) > 0) {
            this.play(animation.getAnimation());
            this.setTimer(animation.getAnimation().getName(), in - 1);
            return true;
        }
        if (animation.getAnimation().getPlaybehaviour() == PlayBehaviourType.LOOP) {
            this.reset(animation);
        }
        return false;
    }

    private void play(TravelersAnimationDefinition definition) {
        definition.sendForEntity(this.entity);
    }

    public void reset(TravelersAnimationWrapper definition) {
        if (this.containsTimer(definition.getAnimation().getName())) {
            this.timers.remove(definition.getAnimation().getName());
        }
    }

    public boolean playTransition(Supplier<Boolean> newCondition, TravelersAnimationWrapper startAnimation, TravelersAnimationWrapper loopedAnimation, TravelersAnimationWrapper outAnimation) {
        String identifier = startAnimation.getAnimation().getName() + ".to." + loopedAnimation.getAnimation().getName() + ".to." + outAnimation.getAnimation().getName();
        String first = identifier + "_first";
        String cur = identifier + "_current";
        String prev = identifier + "_previous";
        if (!this.containsCondition(first) || !this.getCondition(first)) {
            this.setCondition(first, true);
            this.setTimer(outAnimation.getAnimation(), 0);
            this.setTimer(startAnimation.getAnimation(), startAnimation.getTickDuration());
        }
        this.setCondition(prev, this.getCondition(cur));
        this.setCondition(cur, newCondition.get());
        if (this.getCondition(cur)) {
            if (this.play(startAnimation)) {
                return true;
            }
            this.reset(outAnimation);
            if (this.getTimer(startAnimation.getAnimation().getName()) == 0) {
                this.play(loopedAnimation);
                return true;
            }
        } else if (!this.getCondition(prev) && this.play(outAnimation)) {
            this.reset(startAnimation);
            return true;
        }
        return false;
    }

    public void setTimer(TravelersAnimationDefinition name, int time) {
        this.setTimer(name.getName(), time);
    }

    public void setTimer(String name, int time) {
        if (time < 0) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("Attempted to set negative timer for: {}, ignored.", (Object)name);
            }
            return;
        }
        this.timers.put(name, time);
    }

    public int getTimer(String name) {
        if (!this.containsTimer(name)) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("No cooldown with the name '{}' is defined.", (Object)name);
            }
            return -1;
        }
        return this.timers.get(name);
    }

    public boolean containsTimer(String name) {
        return this.timers.containsKey(name);
    }

    public void setCondition(String name, boolean conditionValue) {
        this.conditions.put(name, conditionValue);
    }

    public boolean getCondition(String name) {
        if (!this.containsCondition(name)) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("No condition with the name '{}' is defined.", (Object)name);
            }
            return false;
        }
        return this.conditions.get(name);
    }

    public boolean containsCondition(String name) {
        return this.conditions.containsKey(name);
    }
}

