/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.block;

import com.mojang.serialization.MapCodec;
import com.music.minigolf.block.entity.GolfHoleBlockEntity;
import com.music.minigolf.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GolfHoleBlock
extends BaseEntityBlock {
    public static final MapCodec<GolfHoleBlock> CODEC = GolfHoleBlock.simpleCodec(GolfHoleBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape POLE_SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)24.0, (double)9.0);
    private static final VoxelShape FLAG_SHAPE = Block.box((double)9.0, (double)18.0, (double)7.0, (double)16.0, (double)24.0, (double)9.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)POLE_SHAPE, (VoxelShape)FLAG_SHAPE);

    public GolfHoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return POLE_SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GolfHoleBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return GolfHoleBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.GOLF_HOLE.get()), GolfHoleBlockEntity::serverTick);
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof GolfHoleBlockEntity) {
            GolfHoleBlockEntity hole = (GolfHoleBlockEntity)be;
            if (player.isShiftKeyDown()) {
                hole.decreaseRadius();
            } else {
                hole.increaseRadius();
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.minigolf.hole_radius", (Object[])new Object[]{String.format("%.1f", hole.getRadius())}).withStyle(ChatFormatting.GOLD), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

